<?php

namespace App\Http\Controllers\Admin;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{

    public function index()
    {
        $items = Category::searchable(['name'])->latest()->paginate(getPaginate());
        $pageTitle = 'Manage Categories';
        return view('Admin::category.index', compact('items', 'pageTitle'));
    }


    public function store(Request $request, $id = 0)
    {
        $request->validate([
            'name' => [
                'required',
                function ($attribute, $value, $fail) use ($id) {
                    if (!$value) {
                        return;
                    }

                    $exists = Category::where('name', $value)
                        ->when($id, fn($query) => $query->where('id', '!=', $id))
                        ->exists();

                    if ($exists) {
                        $fail("The $attribute already exists.");
                    }
                },
            ],
            'icon' => 'required',
        ]);

        $category = $id ? Category::findOrFail($id) : new Category();
        $category->name = $request->name;
        $category->icon = $request->icon;
        $category->status = $id ? $category->status : Status::ENABLE;
        $category->save();

        $id ? $notify[] = ['success', 'Category updated successfully'] : $notify[] = ['success', 'Category created successfully'];
        return to_route('admin.category.index')->withNotify($notify);
    }


    public function status($id)
    {
        $category = Category::findOrFail($id);
        $category->status = $category->status == Status::ENABLE ? Status::DISABLE : Status::ENABLE;
        $category->save();

        $notify[] = ['success', 'Category status updated successfully'];
        return to_route('admin.category.index')->withNotify($notify);
    }

}
