<?php

namespace App\Http\Controllers\Admin;

use App\Models\Post;
use App\Models\Comment;
use Illuminate\Http\Request;
use App\Models\PostCommentReport;
use App\Http\Controllers\Controller;

class PostCommentController extends Controller
{
    public function postCommentReports()
    {
        $pageTitle = 'Flags';
        $data = PostCommentReport::with(['post.category', 'comment'])->paginate(getPaginate());
        return view('admin.post_comment_reports.list', compact('pageTitle', 'data'));
    }
    public function postCommentReportsStatus($id)
    {
        $data = PostCommentReport::findOrFail($id);
        $data->status = $this->statusCheck($data);
        if ($data->type == "post") {
            $post = Post::where("id", $data->post_id)->first();
            $post->status = $this->statusCheck($post);
            $notify[] = ['success', 'Post status updated'];
            return redirect()->back()->withNotify($notify);
        } else {
            if ($data->comment_id) {
                $comment = Comment::where("id", $data->comment_id)->first();
                $comment->status = $this->statusCheck($comment);
                $notify[] = ['success', 'Comment status updated'];
                return redirect()->back()->withNotify($notify);
            }

            $notify[] = ['error', 'This property does not exist.'];
            return redirect()->back()->withNotify($notify);
        }
    }

    private function statusCheck($data)
    {
        if ($data->status === 1) {
            $data->status = 0;
            $data->save();
        } elseif ($data->status === 0) {
            $data->status = 1;
            $data->save();
        }
        return $data;
    }
}
