<?php

namespace App\Http\Controllers\Admin;

use App\Models\Post;
use App\Models\PostImage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ApplyJob;
use App\Models\Comment;
use App\Models\CommentVote;
use App\Models\Deposit;
use App\Models\EventParticipant;
use App\Models\PostCommentReport;
use App\Models\PostVote;
use App\Models\Transaction;
use App\Models\VoteCredit;

class PostController extends Controller
{
    public function posts()
    {
        $pageTitle = 'All Posts';
        $posts = $this->postData('text');
        return view('admin.posts.post_list', compact('pageTitle', 'posts'));
    }

    protected function postData($type = null, $scope = null)
    {
        if ($scope) {
            $posts = Post::$scope();
        } else {
            $posts = Post::query();
        }
        return $posts->where('type' , $type)->searchable(['title', 'user:firstname', 'user:lastname', 'user:username', 'category:name'])->with('user','category','apply_job','events')->where('type' , $type)->orderBy('id', 'desc')->paginate(getPaginate());
    }


    public function pending()
    {
        $pageTitle = 'Unpublished Posts';
        $posts = $this->postData('text','pending');
        return view('admin.posts.post_list', compact('pageTitle', 'posts'));
    }


    public function active()
    {
        $pageTitle = 'Published Posts';
        $posts = $this->postData('text','active');
        return view('admin.posts.post_list', compact('pageTitle', 'posts'));
    }

    public function status($id)
    {
        $post = Post::findOrFail($id);
        $post->status = $post->status == 1 ? 0 : 1;
        $post->save();
        $notify[] = ['success', 'Post Status Updated'];
        return redirect()->back()->withNotify($notify);
    }

    public function job_post_list()
    {
        $pageTitle = 'Job Posts';
        $posts = $this->postData('job');
        return view('admin.posts.post_list', compact('pageTitle', 'posts'));
    }

    public function events_post_list()
    {
        $pageTitle = 'Events Posts';
        $posts = $this->postData('event');
        return view('admin.posts.post_list', compact('pageTitle', 'posts'));
    }

    public function deletePost($id)
    {
        $post = Post::find($id);
        $images = PostImage::wherePostId($post->id)->get();
        if($images){
            foreach($images as $image){
                fileManager()->removeFile(getFilePath('posts') . $image->path . $image->image);
                $image->delete();
            }
        }



        $checkApplyPosts = ApplyJob::where('post_id', $post->id)->exists();
        if($checkApplyPosts){
            $applyPosts = ApplyJob::where('post_id', $post->id)->get();
            foreach($applyPosts as $applyPost){
                fileManager()->removeFile(getFilePath('applyJob') . $applyPost->file);
            }
        }



        $checkComments = Comment::where('post_id', $post->id)->exists();
        if($checkComments){
            $comments = Comment::where('post_id', $post->id)->get();
            foreach ($comments as $comment) {
                $commentVotes = CommentVote::where('comment_id', $comment->id)->delete();
            }
        }


        $checkDeposits = Deposit::where('post_id', $post->id)->exists();
        if($checkDeposits){
            $deposits = Deposit::where('post_id', $post->id)->get();
            foreach($deposits as $deposit){
                Transaction::where('trx', $deposit->trx)->delete();
                $deposit->delete();
            }
        }

        $checkEventParticipants = EventParticipant::where('post_id', $post->id)->exists();
        if($checkEventParticipants){
            $eventParticipants = EventParticipant::where('post_id', $post->id)->get();
            foreach($eventParticipants as $eventParticipant){
                $eventParticipant->delete();
            }
        }


        $checkCommentReport = PostCommentReport::where('post_id', $post->id)->exists();
        if($checkCommentReport){
            $commentReports = PostCommentReport::where('post_id', $post->id)->get();
            foreach($commentReports as $commentReport){
                $commentReport->delete();
            }
        }

        $checkPostVotes = PostVote::where('post_id', $post->id)->exists();
        if($checkPostVotes){
            $postVotes = PostVote::where('post_id', $post->id)->get();
            foreach($postVotes as $postVote){
                $postVote->delete();
            }
        }

        $checkVoteCredits = VoteCredit::where('post_id', $post->id)->exists();
        if($checkVoteCredits){
            $voteCredits = VoteCredit::where('post_id', $post->id)->get();
            foreach($voteCredits as $voteCredit){
                $voteCredit->delete();
            }
        }


        $post->images()->delete();
        $post->bookmarks()->delete();
        $post->delete();
        $notify[] = ['success', 'Post Deleted'];
        return redirect()->back()->withNotify($notify);
    }

}
