<?php

namespace App\Http\Controllers\Admin;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\PricePlan;
use Illuminate\Http\Request;


class PricePlanController extends Controller
{
    public function index()
    {
        $items = PricePlan::searchable(['name'])->latest()->paginate(getPaginate());
        $pageTitle = 'Manage Plan Package';
        return view('Admin::plan.index', compact('items', 'pageTitle'));
    }


    public function store(Request $request, $id = 0)
    {
        $request->validate([
            'name' => [
                'required',
                function ($attribute, $value, $fail) use ($id) {
                    if (!$value) {
                        return;
                    }

                    $exists = PricePlan::where('name', $value)
                        ->when($id, fn($query) => $query->where('id', '!=', $id))
                        ->exists();

                    if ($exists) {
                        $fail("The $attribute already exists.");
                    }
                },
            ],
            'price' => 'required|numeric|gte:0',
            'credit' => 'required|numeric|gte:0',
        ]);

        $plan = $id ? PricePlan::findOrFail($id) : new PricePlan();
        $plan->name = $request->name;
        $plan->price = $request->price;
        $plan->credit = $request->credit;
        $plan->status = $id ? $plan->status : Status::ENABLE;
        $plan->save();

        $id ? $notify[] = ['success', 'Plan package updated successfully'] : $notify[] = ['success', 'Plan package created successfully'];
        return to_route('admin.price.plan.index')->withNotify($notify);
    }


    public function status($id)
    {
        $plan = PricePlan::findOrFail($id);
        $plan->status = $plan->status == Status::ENABLE ? Status::DISABLE : Status::ENABLE;
        $plan->save();

        $notify[] = ['success', 'Plan status updated successfully'];
        return to_route('admin.price.plan.index')->withNotify($notify);
    }

}
