<?php

namespace App\Models;


use App\Constants\Status;
use Illuminate\Database\Eloquent\Casts\Attribute;
use App\Models\Post;
use App\Models\User;
use App\Models\Comment;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PostCommentReport extends Model
{
    use HasFactory;

    protected $guarded= ['id'];

    public function scopeRead()
    {
        return $this->where("read","=",0);
    }
    public function post(): BelongsTo
    {
        return $this->belongsTo(Post::class);
    }

    public function comment(): BelongsTo
    {
        return $this->belongsTo(Comment::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function typeBadge(): Attribute
    {
        return new Attribute(
            get:fn () => $this->typeBadgeData(),
        );
    }

    public function typeBadgeData(){
        $html = '';
        if($this->type == 'post'){
            $html = '<span class="badge badge--success">'.trans("Post").'</span>';
        }else{
            $html = '<span class="badge badge--warning">'.trans("Comment").'</span>';
        }

        return $html;
    }


    public function statusBadge(): Attribute
    {
        return new Attribute(
            get:fn () => $this->statusBadgeData(),
        );
    }

    public function statusBadgeData(){
        $html = '';
        if($this->status == Status::ENABLE){
            $html = '<span class="badge badge--success">'.trans("Enable").'</span>';
        }else{
            $html = '<span class="badge badge--warning">'.trans("Disable").'</span>';
        }

        return $html;
    }
}
