@extends('admin.layouts.app')

@section('panel')
    <div class="row gy-4 justify-content-between mb-3 pb-3">
        <div class="col-xl-4 col-md-6">
            <div class="d-flex flex-wrap justify-content-start w-100">
                <form class="form-inline w-100">
                    <div class="search-input--wrap position-relative">
                        <input type="text" name="search" class="form-control" placeholder="@lang('Search')..." value="{{ request()->search ?? '' }}">
                        <button class="search--btn position-absolute"><i class="fa fa-search"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="row gy-4">
        <div class="col-md-12 mb-30">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two custom-data-table">
                            <thead>
                                <tr>
                                    <th>@lang('SI')</th>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Icon')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Actions')</th>
                                </tr>
                            </thead>
                            <tbody id="items_table__body">
                                @forelse ($items as $category)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ __($category->name) }}</td>
                                        <td>@php echo  $category->icon ; @endphp</td>
                                        <td>
                                            @php echo $category->statusBadge; @endphp
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-end align-items-center gap-2">
                                                <div class="form-group mb-0">
                                                    <label class="switch m-0" title="@lang('Change Status')">
                                                        <input type="checkbox" class="toggle-switch confirmationBtn" data-action="{{ route('admin.category.status', $category->id) }}"
                                                        data-question="@lang('Are you sure to change category status from this system?')" @checked($category->status)>
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>

                                                <button title="@lang('Edit')" type="button" class="btn btn-sm editBtn" data-category="{{ json_encode($category->only('name', 'icon')) }}" data-action="{{ route('admin.category.store', $category->id) }}">
                                                    <i class="fa-solid fa-pen-to-square"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                <div id="pagination-wrapper"  class="pagination__wrapper py-4 {{ $items->hasPages() ? '' : 'd-none' }}">
                    @if ($items->hasPages())
                    {{ paginateLinks($items) }}
                    @endif
                </div>

            </div>
        </div>
    </div>

    {{-- ROLE MODAL --}}
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Category')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    </button>
                </div>
                <form method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label> @lang('Name')</label>
                            <input class="form-control" id="editName" name="name" type="text" required>
                        </div>

                        <div class="form-group">
                            <label>@lang('Icon')</label>
                            <div class="input-group">
                                <input type="text" class="form-control iconPicker icon" autocomplete="off" name="icon" required>
                                <span class="input-group-text  input-group-addon" data-icon="las la-home" role="iconpicker"></span>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" id="editBtn" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal></x-confirmation-modal>
@endsection

@push('breadcrumb-plugins')
    <a class="btn btn--primary add__btn" href="javascript:void(0)" data-action="{{ route('admin.category.store', ['id' => 0]) }}"><i class="fa-solid fa-plus"></i> @lang('Add New')</a>
@endpush


@push('style-lib')
    <link href="{{ asset('assets/admin/css/fontawesome-iconpicker.min.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/fontawesome-iconpicker.js') }}"></script>
@endpush



@push('script')
    <script>
        (function ($) {
            'use strict';

            $('.iconPicker').iconpicker().on('iconpickerSelected', function(e) {
                $(this).closest('.form-group').find('.iconpicker-input').val(`<i class="${e.iconpickerValue}"></i>`);
            });


            $(document).on('click', '.editBtn', function() {
                var modal = $('#editModal');
                modal.find('.modal-title').text("@lang('Update Category')");
                var category = $(this).data('category');
                modal.find('input[name=name]').val(category.name);
                modal.find('input[name=icon]').val(category.icon);
                modal.find('.input-group .input-group-text.input-group-addon').html(category.icon);
                modal.find('form').attr('action', $(this).data('action'));
                modal.find('#editBtn').text("@lang('Update')");
                modal.modal('show');
            });

            $('.add__btn').on('click', function() {
                var modal = $('#editModal');
                modal.find('.modal-title').text("@lang('Add New Category')");
                modal.find('input[name=name]').val('');
                modal.find('input[name=icon]').val('');
                modal.find('.input-group .input-group-text.input-group-addon').html('');
                modal.find('form').attr('action', $(this).data('action'));
                modal.find('#editBtn').text("@lang('Submit')");
                modal.modal('show');
            });


        })(jQuery);
    </script>
@endpush
