@extends('admin.layouts.app')

@section('panel')
    <div class="row gy-4 justify-content-between mb-3 pb-3">
        <div class="col-xl-4 col-md-6">
            <div class="d-flex flex-wrap justify-content-start w-100">
                <form class="form-inline w-100">
                    <div class="search-input--wrap position-relative">
                        <input type="text" name="search" class="form-control" placeholder="@lang('Search')..." value="{{ request()->search ?? '' }}">
                        <button class="search--btn position-absolute"><i class="fa fa-search"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="row gy-4">
        <div class="col-md-12 mb-30">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two custom-data-table">
                            <thead>
                                <tr>
                                    <th>@lang('SI')</th>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Credit')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Actions')</th>
                                </tr>
                            </thead>
                            <tbody id="items_table__body">
                                @forelse ($items as $item)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ __($item->name) }}</td>
                                        <td>
                                            {{ $general->cur_sym }}{{ showAmount($item->price, 2) }}
                                        </td>
                                        <td>
                                            {{ $item->credit }}
                                        </td>
                                        <td>
                                            @php echo $item->statusBadge; @endphp
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-end align-items-center gap-2">
                                                <div class="form-group mb-0">
                                                    <label class="switch m-0" title="@lang('Change Status')">
                                                        <input type="checkbox" class="toggle-switch confirmationBtn" data-action="{{ route('admin.price.plan.status', $item->id) }}"
                                                        data-question="@lang('Are you sure to change category status from this system?')" @checked($item->status)>
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>

                                                <button title="@lang('Edit')" type="button" class="btn btn-sm editBtn" data-plan="{{ json_encode($item->only('name', 'price', 'credit')) }}" data-action="{{ route('admin.price.plan.store', $item->id) }}">
                                                    <i class="fa-solid fa-pen-to-square"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                <div id="pagination-wrapper"  class="pagination__wrapper py-4 {{ $items->hasPages() ? '' : 'd-none' }}">
                    @if ($items->hasPages())
                    {{ paginateLinks($items) }}
                    @endif
                </div>

            </div>
        </div>
    </div>

    {{-- ROLE MODAL --}}
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Plan Management')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    </button>
                </div>
                <form method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label> @lang('Name')</label>
                            <input class="form-control"  name="name" type="text" value="{{ old('name') }}" required>
                        </div>

                        <div class="form-group">
                            <label>@lang('Price')</label>
                            <input type="text" class="form-control" value="{{ old('price') }}" name="price" required>
                        </div>

                        <div class="form-group">
                            <label>@lang('Credit')</label>
                            <input type="text" class="form-control" value="{{ old('credit') }}" name="credit" required>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" id="editBtn" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal></x-confirmation-modal>
@endsection

@push('breadcrumb-plugins')
    <a class="btn btn--primary add__btn" href="javascript:void(0)" data-action="{{ route('admin.price.plan.store', ['id' => 0]) }}"><i class="fa-solid fa-plus"></i> @lang('Add New')</a>
@endpush


@push('script')
    <script>
        (function ($) {
            'use strict';

            $(document).on('click', '.editBtn', function() {
                var modal = $('#editModal');
                modal.find('.modal-title').text("@lang('Update Plan Package')");
                var plan = $(this).data('plan');
                modal.find('input[name=name]').val(plan.name);
                modal.find('input[name=price]').val(plan.price);
                modal.find('input[name=credit]').val(plan.credit);
                modal.find('form').attr('action', $(this).data('action'));
                modal.find('#editBtn').text("@lang('Update')");
                modal.modal('show');
            });

            $('.add__btn').on('click', function() {
                var modal = $('#editModal');
                modal.find('.modal-title').text("@lang('Add New Plan')");
                modal.find('input[name=name]').val('');
                modal.find('input[name=price]').val('');
                modal.find('input[name=credit]').val('');
                modal.find('form').attr('action', $(this).data('action'));
                modal.find('#editBtn').text("@lang('Submit')");
                modal.modal('show');
            });


        })(jQuery);
    </script>
@endpush
