@extends('admin.layouts.app')

@section('panel')
    <div class="row gy-4 justify-content-between mb-3 pb-3">
        <div class="col-xl-4 col-md-6">
            <div class="d-flex flex-wrap justify-content-start w-100">
                <form class="form-inline w-100">
                    <div class="search-input--wrap position-relative">
                        <input type="text" name="search" class="form-control" placeholder="@lang('Search')..." value="{{ request()->search ?? '' }}">
                        <button class="search--btn position-absolute"><i class="fa fa-search"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="row gy-4">
        <div class="col-md-12 mb-30">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two custom-data-table">
                            <thead>
                                <tr>
                                    <th>@lang('Post Title')</th>
                                    <th>@lang('Type')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody id="items_table__body">
                                @forelse($data as $item)
                                    <tr>
                                        <td>
                                            {{ __(@$item->post?->title) }}
                                        </td>
                                        <td>
                                            @php echo $item->typeBadge; @endphp
                                        </td>
                                        <td>
                                            @php echo $item->statusBadge; @endphp
                                        </td>


                                        <td>
                                            <div class="d-flex justify-content-end align-items-center gap-2">
                                                <div class="form-group mb-0">
                                                    <label class="switch m-0" title="@lang('Change Status')">
                                                        <input type="checkbox" class="toggle-switch confirmationBtn" data-action="{{ route('admin.post.comment.status', $item->id) }}"
                                                        data-question="@lang('Are you sure to change flag status from this system?')" @checked($item->status)>
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>

                                                <a href="{{ route('post.details',[@$item?->post?->id, slug(@$item?->post?->title)]) }}" target="_blank" title="@lang('Post Details')" class="btn btn-sm">
                                                    <i class="fa-solid fa-eye"></i>
                                                </a>
                                                <button title="@lang('View Reason')" type="button" class="btn btn-sm reason" data-id="{{ $item->id }}" data-reason="{{ $item->reason }}">
                                                    <i class="fa-solid fa-info"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                <div id="pagination-wrapper"  class="pagination__wrapper py-4 {{ $data->hasPages() ? '' : 'd-none' }}">
                    @if ($data->hasPages())
                    {{ paginateLinks($data) }}
                    @endif
                </div>

            </div>
        </div>
    </div>

    <div id="reasonModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Post Report Reason')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    </button>
                </div>
                <div class="modal-body">
                    <p class="reason-text"></p>
                </div>
            </div>
        </div>
    </div>
    <x-confirmation-modal></x-confirmation-modal>
@endsection



@push('script')
    <script>
        (function($) {
            "use strict";
            $(".reason").on('click',function() {
                $('.reason-text').text($(this).data('reason'))
                $("#reasonModal").modal('show');
            });

        })(jQuery);

    </script>
@endpush
