@extends('admin.layouts.app')

@section('panel')
    <div class="row gy-4 justify-content-between mb-3 pb-3">
        <div class="col-xl-4 col-md-6">
            <div class="d-flex flex-wrap justify-content-start w-100">
                <form class="form-inline w-100">
                    <div class="search-input--wrap position-relative">
                        <input type="search" name="search" class="form-control" placeholder="@lang('Search title, user, category')..." value="{{ request()->search ?? '' }}">
                        <button class="search--btn position-absolute"><i class="fa fa-search"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="row gy-4">
        <div class="col-md-12 mb-30">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two custom-data-table">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th>@lang('Title')</th>
                                    <th>@lang('Candidates')</th>
                                    <th>@lang('Views')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody id="items_table__body">
                                 @forelse($posts as $post)
                                    <tr>
                                        <td class="user--td">
                                            <div class="d-flex justify-content-between justify-content-lg-start gap-3">
                                                <div class="user--info d-flex gap-3 flex-shrink-0 align-items-center flex-wrap flex-md-nowrap">
                                                    <div class="user--thumb-two">
                                                        @if(!empty($post?->user?->image))
                                                            <img src="{{ getImage(getFilePath('userProfile') . '/' . $post?->user?->image ) }}" alt="@lang('Image')">
                                                        @else
                                                            <img src="{{ getImage('assets/images/general/avatar.png') }}" alt="@lang('Image')">
                                                        @endif
                                                    </div>
                                                    <div class="user--content">
                                                        <a class="text-start text-dark" href="{{ appendQuery('search', $post?->user?->username) }}">
                                                            {{ $post->user->fullname }}
                                                        </a>
                                                        <br>
                                                        <a href="{{ route('admin.users.detail', $post?->user_id) }}" class="text-start">{{ '@'.__($post?->user?->username) }}</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            {{ __(@$post->title) }}
                                        </td>
                                        <td>
                                            {{ __(@$post->events?->count()) }}
                                        </td>
                                        <td>
                                            {{ ($post->views) }}
                                        </td>
                                        <td>
                                            <a title="@lang('View Post')" target="_blank" href="{{ route('post.details', [$post->id, slug($post->title)]) }}"
                                                class="btn btn-sm">
                                                <i class="fa-solid fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                <div id="pagination-wrapper"  class="pagination__wrapper py-4 {{ $posts->hasPages() ? '' : 'd-none' }}">
                    @if ($posts->hasPages())
                    {{ paginateLinks($posts) }}
                    @endif
                </div>

            </div>
        </div>
    </div>

@endsection


