@php
    $hmenu = App\Models\Menu::where('code', 'left_sidemenu')->first();
    $pages = $hmenu->items()->get();

    $omenu = App\Models\Menu::where('code', 'others_menu')->latest()->first();
    $othersPages = $omenu->items()->get();
@endphp
<!-- left side -->
<div class="col-lg-3">
    <aside class="leftside-bar">
        <!-- menu-item-wraper -->
        <div class="menu-item-wraper">
            <div class="nav-menu">
                <div class="navmenu-item-wraper">
                    @if($pages)
                        @foreach($pages as $k => $data)
                            @if($data->link_type == 2)
                                <a href="{{ $data->url ?? '' }}" target="_blank" class="menu-item">
                                    @php echo  $data->icon ; @endphp
                                    <h6 class="menu-name">{{__($data->title)}}</h6>
                                </a>
                            @else
                                <a href="{{route('pages',[$data->url])}}" class="menu-item">
                                    @php echo  $data->icon ; @endphp
                                    <h6 class="menu-name {{ route('pages',[$data->url]) == url()->current() ? 'active' : null }}">{{__($data->title)}}</h6>
                                </a>
                            @endif
                        @endforeach
                    @endif
                    @auth
                    <a href="{{ route('save.post') }}" class="menu-item">
                        <i class="fa-solid fa-bookmark"></i>
                        <h6 class="menu-name {{ menuActive('save.post') }}">@lang('Bookmarks')</h6>
                    </a>
                    @endauth

                </div>
            </div>
            <!-- menu-item-wraper / -->
            <!-- latest-topics-menu -->
            <div class="latest-topics-menu">
                <div class="latest-topics-wraper">
                    <h6 class="menu-title">@lang('TOPICS')</h6>
                    <div class="latest-topics-list">
                        @foreach ($categories as $category)
                            @if ($loop->iteration > 0 && $loop->iteration <= 4)
                                <a href="{{ route('post.category', [slug($category->name), $category->id]) }}"
                                    class="menu-item">
                                    @php echo  $category->icon ; @endphp
                                    <h6
                                        class="menu-name {{ url()->current() == route('post.category', [slug($category->name), $category->id]) ? 'active' : '' }}">
                                        {{ $category->name }}</h6>
                                </a>
                            @endif
                            @if ($loop->iteration > 4)
                                <div class="show-all-menu-wraper">
                                    <div class="show-all-menu-item">
                                        <a href="{{ route('post.category', [slug($category->name), $category->id]) }}"
                                            class="menu-item">
                                            @php echo  $category->icon ; @endphp
                                            <h6 class="menu-name">{{ $category->name }}</h6>
                                        </a>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                        <div class="menu-item">
                            <button class="show-all-tgl-btn">@lang('See More')</button>
                        </div>

                    </div>
                </div>
            </div>
            <!-- latest-topics-menu / -->

            <!-- others-menu -->
            <div class="others-menu">
                <div class="others-item-wraper">
                    <h6 class="menu-title">@lang('Others')</h6>
                    @if($othersPages)
                        @foreach($othersPages as $k => $data)
                            @if($k == 0)
                            <div class="others-item-list">
                            @endif
                            @if($data->link_type == 2)
                                <a href="{{ $data->url ?? '' }}" target="_blank" class="menu-item">
                                    @php echo  $data->icon ; @endphp
                                    <h6 class="menu-name">{{__($data->title)}}</h6>
                                </a>
                            @else
                                <a href="{{route('pages',[$data->url])}}" class="menu-item">
                                     @php echo  $data->icon ; @endphp
                                    <h6 class="menu-name {{ route('pages',[$data->url]) == url()->current() ? 'active' : null }}">{{__($data->title)}}</h6>
                                </a>
                            @endif
                            @if($k == 0)
                            </div>
                            @endif
                        @endforeach
                    @endif
                </div>
            </div>
            <!-- others-menu /-->

            <div class="copy-right-text text-center ps-5 mt-4">
                <p class="bottom-footer-text"> &copy; @lang('Copyright') {{ now()->year }} @lang('. All rights reserved.')</p>
            </div>
        </div>
    </aside>
</div>
<!-- left side / -->
