@php
    $omenu = App\Models\Menu::where('code', 'others_menu')->latest()->first();
    $othersPages = $omenu->items()->get();
@endphp
<!-- left side -->
<div class="col-lg-3">
    <aside class="leftside-bar">
        <!-- menu-item-wraper -->
        <div class="menu-item-wraper">
            <div class="nav-menu">
                <div class="navmenu-item-wraper">
                    <a href="{{ route('user.home') }}" class="menu-item">
                        <span class="icon"><i class="fa fa-tachometer-alt"></i></span>
                        <h6 class="text {{ menuActive('user.home') }}">@lang('Dashboard')</h6>
                    </a>
                    <a href="{{ route('user.notification.index') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-bell"></i></span>
                        <h6 class="text {{ menuActive('user.notification.index') }}">@lang('Notification')</h6>
                        @if ($user_notification > 0)
                            <span class="pulse">
                            </span>
                        @endif
                    </a>

                    <a href="{{ route('user.price.plan.index') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-award"></i></span>
                        <h6 class="text {{ menuActive('user.price.plan.index') }}">@lang('Price Plan')</h6>
                    </a>


                    <a href="{{ route('user.refill.plan.index') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-retweet"></i></span>
                        <h6 class="text {{ menuActive('user.refill.plan.index') }}">@lang('Refill Plan')</h6>
                    </a>

                    <a href="{{ route('user.post.job') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-toolbox"></i></span>
                        <h6 class="text {{ menuActive('user.post.job') }}">@lang('My Jobs')</h6>
                    </a>
                    <a href="{{ route('user.post.applied.jobs') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-toolbox"></i></span>
                        <h6 class="text {{ menuActive('user.post.applied.jobs') }}">@lang('Applied Jobs')</h6>
                    </a>


                    <a href="{{ route('user.events.lists') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-calendar-days"></i></span>
                        <h6 class="text {{ menuActive('user.events.lists') }}">@lang('My Events')</h6>
                    </a>
                    <a href="{{ route('user.events.joined.events') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-calendar-days"></i></span>
                        <h6 class="text {{ menuActive('user.events.joined.events') }}">@lang('Joined Events')</h6>
                    </a>

                    <a href="{{ route('user.deposit.history') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-receipt"></i></span>
                        <h6 class="text {{ menuActive('user.deposit.history') }}">@lang('Deposit Log')</h6>
                    </a>


                    <a href="{{ route('user.transactions') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-dollar"></i></span>
                        <h6 class="text {{ menuActive('user.transactions') }}">@lang('Transaction Log')</h6>
                    </a>

                    <a href="{{ route('user.withdraw') }}" class="menu-item">
                        <span class="icon"><i class="fas fa-money-bill-alt"></i></span>
                        <h6 class="text {{ menuActive('user.withdraw') }}">@lang('Withdrawal')</h6>
                    </a>

                    <a href="{{ route('user.withdraw.history') }}" class="menu-item">
                        <span class="icon"><i class="fas fa-hand-holding-usd"></i></span>
                        <h6 class="text {{ menuActive('user.withdraw.history') }}">@lang('Withdraw Log')</h6>
                    </a>

                    <a href="{{ route('user.profile.setting') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-screwdriver-wrench"></i></span>
                        <h6 class="text {{ menuActive('user.profile.setting') }}">@lang('Profile Setting')</h6>
                    </a>

                    <a href="{{ route('user.change.password') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-unlock-keyhole"></i></span>
                        <h6 class="text {{ menuActive('user.change.password') }}">@lang('Change Password')</h6>
                    </a>

                    <a href="{{ route('user.twofactor') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-signs-post"></i></span>
                        <h6 class="text {{ menuActive('user.twofactor') }}">@lang('2Fa Security')</h6>
                    </a>

                    <a href="{{ route('ticket') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-ticket"></i></span>
                        <h6 class="text {{ menuActive('ticket') }}">@lang('Support Ticket')</h6>
                    </a>

                    <a href="{{ route('user.logout') }}" class="menu-item">
                        <span class="icon"><i class="fa-solid fa-arrow-right-from-bracket text-danger"></i></span>
                        <h6 class="text {{ menuActive('user.logout') }}">@lang('Log Out')</h6>
                    </a>

                </div>
            </div>
            <!-- menu-item-wraper / -->

            <!-- latest-topics-menu -->
            <div class="latest-topics-menu">
                <div class="latest-topics-wraper">
                    <h6 class="menu-title">@lang('TOPICS')</h6>
                    <div class="latest-topics-list">
                        @foreach ($categories as $category)
                            @if ($loop->iteration > 0 && $loop->iteration <= 5)
                                <a href="{{ route('post.category', [slug($category->name), $category->id]) }}"
                                    class="menu-item">
                                    <span>
                                        @php echo  $category->icon ; @endphp
                                    </span>

                                    <h6 class="menu-name {{ (url()->current() == route('post.category', [slug($category->name), $category->id])) ? 'active' : '' }}">{{ $category->name }}</h6>
                                </a>
                            @endif
                            @if ($loop->iteration > 5)
                                <div class="show-all-menu-wraper">
                                    <div class="show-all-menu-item">
                                        <a href="{{ route('post.category', [slug($category->name), $category->id]) }}"
                                            class="menu-item">
                                            <span>
                                                @php echo  $category->icon ; @endphp
                                            </span>
                                            <h6 class="menu-name ">{{ $category->name }}</h6>
                                        </a>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                        <div class="menu-item">
                            <button class="show-all-tgl-btn">@lang('See More')</button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- latest-topics-menu / -->

            <!-- others-menu -->
            <div class="others-menu">
                <div class="others-item-wraper">
                    <h6 class="menu-title">@lang('Others')</h6>
                    @if($othersPages)
                        @foreach($othersPages as $k => $data)
                            @if($k == 0)
                            <div class="others-item-list">
                            @endif
                            @if($data->link_type == 2)
                                <a href="{{ $data->url ?? '' }}" target="_blank" class="menu-item">
                                    @php echo  $data->icon ; @endphp
                                    <h6 class="menu-name">{{__($data->title)}}</h6>
                                </a>
                            @else
                                <a href="{{route('pages',[$data->url])}}" class="menu-item">
                                     @php echo  $data->icon ; @endphp
                                    <h6 class="menu-name {{ route('pages',[$data->url]) == url()->current() ? 'active' : null }}">{{__($data->title)}}</h6>
                                </a>
                            @endif
                            @if($k == 0)
                            </div>
                            @endif
                        @endforeach
                    @endif
                </div>
            </div>
            <!-- others-menu /-->
            <div class="copy-right-text text-center ps-5 pb-5 mt-4">
                <p class="bottom-footer-text"> &copy; @lang('Copyright') {{ now()->year }} @lang('. All rights reserved.') </p>
            </div>
        </div>
    </aside>
</div>
<!-- left side / -->

@push('style')
    <style>
        .pulse {

            display: block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: hsl(var(--base));
            cursor: pointer;
            box-shadow: 0 0 0 rgba(163, 185, 227, 0.4);
            animation: pulse 2s infinite;
        }

        .copy-right-text{
            padding-bottom: 100px !important;
        }

        .pulse:hover {
            animation: none;
        }

        @keyframes pulse {
            0% {
                -moz-box-shadow: 0 0 0 0 rgba(99, 106, 130, 0.4);
                box-shadow: 0 0 0 0 rgba(99, 106, 130, 0.4);
            }

            70% {
                -moz-box-shadow: 0 0 0 10px rgba(116, 122, 201, 0);
                box-shadow: 0 0 0 10px rgba(116, 122, 201, 0);
            }

            100% {
                -moz-box-shadow: 0 0 0 0 rgba(13, 2, 108, 0);
                box-shadow: 0 0 0 0 rgba(13, 2, 108, 0);
            }
        }
    </style>
@endpush
