@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section>
        <!-- header -->
        @include('presets.default.components.header')
        @include('presets.default.components.sidenav')

        <!-- body -->
        <div class="body-section">
            <div class="container-fluid">
                <div class="row m-0">
                    <!-- left side -->
                    @include('presets.default.components.user.sidebar')
                    <!-- left side / -->
                    {{-- main content --}}
                    <div class="col-xl-6 col-lg-6">
                        <div class="row pt-80 justify-content-center gy-4 px-3">
                            <div class="col-lg-12 ">
                                <div class="order-wrap mt-3">
                                    <div class="row justify-content-end">
                                        <div class="col-md-3 mb-3">
                                            <form>
                                                <div class="search-box w-100">
                                                    <input type="text" name="search" class="form--control"
                                                        value="{{ request()->search }}" placeholder="@lang('Search...')">
                                                    <button type="submit" class="search-box__button"><i
                                                            class="fas fa-search"></i></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <div class="table-responsive table-wrap">
                                        <table class="table table--responsive--xl">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">@lang('Title')</th>
                                                    <th class="text-center">@lang('Fee')</th>
                                                    <th class="text-center">@lang('Start date')</th>
                                                    <th class="text-center">@lang('End date')</th>
                                                    <th class="text-center">@lang('Status')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($events as $event)
                                                    <tr>
                                                        <td class="text-center" data-label="Title">{{ __($event?->post?->title) }}</td>
                                                        <td data-label="fee">{{ $general->cur_sym }}{{ showAmount($event?->post?->fee) }}
                                                        </td>
                                                        <td data-label="Start date">{{ showDateTime($event?->post?->start_date,'d M Y, h:i A') }}</td>

                                                        <td data-label="End date">{{ showDateTime(@$event?->post?->end_date,'d M Y, h:i A') }}</td>
                                                        <td data-label="status">
                                                            @if($event->status == 1)
                                                                <span class="badge badge--success">@lang('Paid')</span>
                                                            @else
                                                                <span class="badge badge--warning">@lang('Unpaid')</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td class="text-muted text-center" data-label="Details" colspan="100%">{{ __($emptyMessage) }}</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                        <div class="row justify-content-end mt-3">
                                            <div class="col-md-3 mb-3">
                                                {{ $events->links() }}
                                            </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- main content / --}}

                    <!-- right side -->
                    <div class="col-lg-3">
                        <aside class="rightside-bar">
                            @include('presets.default.components.user_info')
                            @include('presets.default.components.popular')
                        </aside>
                    </div>
                    <!-- right side /-->


                </div>
            </div>
        </div>
    </section>
@endsection


