@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section>
        <!-- header -->
        @include('presets.default.components.header')
        @include('presets.default.components.sidenav')

        <!-- body -->
        <div class="body-section">
            <div class="container-fluid">
                <div class="row m-0">
                    <!-- left side -->
                    @include('presets.default.components.user.sidebar')
                    <!-- left side / -->
                    {{-- main content --}}
                    <div class="col-xl-6 col-lg-6">
                        <div class="row pt-80 justify-content-center gy-4 px-3">
                            <div class="col-lg-12 ">
                                <div class="order-wrap mt-3">
                                    <div class="row justify-content-end">
                                        <div class="col-md-3 mb-3">
                                            <form>
                                                <div class="search-box w-100">
                                                    <input type="text" name="search" class="form--control"
                                                        value="{{ request()->search }}" placeholder="@lang('Search...')">
                                                    <button type="submit" class="search-box__button"><i
                                                            class="fas fa-search"></i></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <div class="table-responsive table-wrap">
                                        <table class="table table--responsive--xl">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">@lang('Title')</th>
                                                    <th class="text-center">@lang('Salary')</th>
                                                    <th class="text-center">@lang('Expected Salary')</th>
                                                    <th class="text-center">@lang('Applied At')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($jobs as $job)
                                                    <tr>
                                                        <td class="text-center" data-label="@lang('Title')">{{ __($job?->post?->title) }}</td>
                                                        <td data-label="@lang('Salary')">{{ __($general->cur_sym) }}{{ showAmount($job?->post?->salary) }}
                                                        </td>
                                                        <td data-label="@lang('Expected Salary')">{{ __($general->cur_sym) }}{{ showAmount($job?->expect_salary) }}
                                                        </td>
                                                        <td data-label="@lang('Applied At')" class="text-center">
                                                            {{ showDateTime($job->created_at) }}
                                                        </td>


                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td class="text-muted text-center" data-label="@lang('Applied Job list')" colspan="100%">{{ __($emptyMessage) }}</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                        <div class="row justify-content-end mt-3">
                                            <div class="col-md-3 mb-3">
                                                {{ $jobs->links() }}
                                            </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- main content / --}}

                    <!-- right side -->
                    <div class="col-lg-3">
                        <aside class="rightside-bar">
                            @include('presets.default.components.user_info')
                            @include('presets.default.components.popular')
                        </aside>
                    </div>
                    <!-- right side /-->


                </div>
            </div>
        </div>
    </section>
@endsection


