@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section>
        <!-- header -->
        @include('presets.default.components.header')
        @include('presets.default.components.sidenav')

        <!-- body -->
        <div class="body-section">
            <div class="container-fluid">
                <div class="row m-0 ">
                    <!-- left side -->
                    @include('presets.default.components.user.sidebar')
                    <!-- left side / -->
                    {{-- main content --}}
                    <div class="col-xl-6 col-lg-6">
                        <div class="row pt-80 justify-content-center gy-4 px-3">
                            <div class="col-lg-12">
                                <div class="order-wrap">
                                    <div class="row justify-content-end">
                                        <div class="col-md-3 mb-3">
                                            <form>
                                                <div class="search-box w-100">
                                                    <input type="text" name="search" class="form--control"
                                                        value="{{ request()->search }}" placeholder="@lang('Search...')">
                                                    <button type="submit" class="search-box__button"><i
                                                            class="fas fa-search"></i></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <div class="table-responsive table-wrap">
                                        <table class="table table--responsive--xl">
                                            <thead>
                                                <tr>
                                                    <th>@lang('Trx')</th>
                                                    <th>@lang('Transacted')</th>
                                                    <th>@lang('Amount')</th>
                                                    <th>@lang('Post Balance')</th>
                                                    <th>@lang('Detail')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($transactions as $trx)
                                                    <tr>
                                                        <td>
                                                            <strong>{{ $trx->trx }}</strong>
                                                        </td>

                                                        <td>
                                                            {{ showDateTime($trx->created_at) }}<br>{{ diffForHumans($trx->created_at) }}
                                                        </td>

                                                        <td class="budget">
                                                            <span
                                                                class="fw-bold @if ($trx->trx_type == '+') text-success @else text-danger @endif">
                                                                {{ $trx->trx_type }} {{ showAmount($trx->amount) }}
                                                                {{ $general->cur_text }}
                                                            </span>
                                                        </td>

                                                        <td class="budget">
                                                            {{ showAmount($trx->post_balance) }} {{ __($general->cur_text) }}
                                                        </td>


                                                        <td>{{ __($trx->details) }}</td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}
                                                        </td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                        {{ $transactions->links() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- main content / --}}

                    <!-- right side -->
                    <div class="col-lg-3">
                        <aside class="rightside-bar">
                            @include('presets.default.components.user_info')
                            @include('presets.default.components.popular')
                        </aside>
                    </div>
                    <!-- right side /-->
                </div>
            </div>
        </div>

    </section>
@endsection




