<?php
use Illuminate\Support\Facades\Route;

Route::middleware('guest')->namespace('User\Auth')->name('user.')->group(function () {

    Route::controller('LoginController')->group(function(){
        Route::get('/login', 'showLoginForm')->name('login');
        Route::post('/login', 'login');
        Route::get('logout', 'logout')->middleware('auth')->withoutMiddleware('guest')->name('logout');
    });

    Route::controller('RegisterController')->group(function(){
        Route::get('register', 'showRegistrationForm')->name('register');
        Route::post('register', 'register')->middleware('registration.status');
        Route::post('check-mail', 'checkUser')->name('checkUser')->withoutMiddleware('guest');
    });

    Route::controller('ForgotPasswordController')->prefix('password')->name('password.')->group(function(){
        Route::get('reset', 'showLinkRequestForm')->name('request');
        Route::post('email', 'sendResetCodeEmail')->name('email');
        Route::get('code-verify', 'codeVerify')->name('code.verify');
        Route::post('verify-code', 'verifyCode')->name('verify.code');
    });
    Route::controller('ResetPasswordController')->group(function(){
        Route::post('password/reset', 'reset')->name('password.update');
        Route::get('password/reset/{token}', 'showResetForm')->name('password.reset');
    });

    Route::controller('SocialiteController')->prefix('social')->group(function () {
        Route::get('login/{provider}', 'socialLogin')->name('social.login');
        Route::get('login/callback/{provider}', 'callback')->name('social.login.callback');
    });
});

Route::middleware('auth')->name('user.')->group(function () {
    //authorization
    Route::namespace('User')->controller('AuthorizationController')->group(function(){
        Route::get('authorization', 'authorizeForm')->name('authorization');
        Route::get('resend/verify/{type}', 'sendVerifyCode')->name('send.verify.code');
        Route::post('verify/email', 'emailVerification')->name('verify.email');
        Route::post('verify/mobile', 'mobileVerification')->name('verify.mobile');
        Route::post('verify/g2fa', 'g2faVerification')->name('go2fa.verify');
    });

    Route::middleware(['check.status'])->group(function () {

        Route::get('user/data', 'User\UserController@userData')->name('data');
        Route::post('user/data/submit', 'User\UserController@userDataSubmit')->name('data.submit');

        Route::middleware('registration.complete')->namespace('User')->group(function () {

            Route::controller('UserController')->group(function(){
                Route::get('dashboard', 'home')->name('home');

                //2FA
                Route::get('twofactor', 'show2faForm')->name('twofactor');
                Route::post('twofactor/enable', 'create2fa')->name('twofactor.enable');
                Route::post('twofactor/disable', 'disable2fa')->name('twofactor.disable');

                //Report
                Route::any('deposit/history', 'depositHistory')->name('deposit.history');
                Route::get('transactions','transactions')->name('transactions');
                Route::get('attachment-download/{fil_hash}','attachmentDownload')->name('attachment.download');
            });

            //Profile setting
            Route::controller('ProfileController')->group(function(){
                Route::get('profile/setting', 'profile')->name('profile.setting');
                Route::post('profile/setting', 'submitProfile');
                Route::get('change-password', 'changePassword')->name('change.password');
                Route::post('change-password', 'submitPassword');
                Route::post('profile-image', 'profileUpdate')->name('profile.image.update');


                Route::get('experience', 'experience')->name('experience.index');
                Route::post('experience/store', 'experienceStore')->name('experience.store');
                Route::get('experience/edit/{experience}', 'experienceEdit')->name('experience.edit');
                Route::post('experience/update/{experience}', 'experienceUpdate')->name('experience.update');
                Route::get('experience/delete/{id}', 'experienceDelete')->name('experience.delete');
            });


            // Withdraw
            Route::controller('WithdrawController')->prefix('withdraw')->name('withdraw')->group(function(){
                Route::get('/', 'withdrawMoney');
                Route::post('/', 'withdrawStore')->name('.money');
                Route::get('preview', 'withdrawPreview')->name('.preview');
                Route::post('preview', 'withdrawSubmit')->name('.submit');
                Route::get('history', 'withdrawLog')->name('.history');
            });






                        // User Post
            Route::controller('PostController')->prefix('post')->name('post.')->group(function () {
                Route::post('/store', 'store')->name("store");
                Route::get('/edit/{id}', 'edit')->name("edit");
                Route::post('/update/{id}', 'update')->name("update");
                Route::post('/image', 'postImageDelete')->name("image");
            });

            Route::controller('PostController')->name('post.')->group(function () {
                Route::get('/job-lists', 'job_list')->name("job");
                Route::get('applied-jobs', 'applied_jobs')->name("applied.jobs");
                Route::post('/status/change', 'postStatus')->name("status");
            });

            // Apply job Controller
            Route::controller('ApplyJobController')->name('apply.job.')->group(function () {
                Route::post('/store', 'store')->name("store");
                Route::get('/all-candidate/{id}', 'all_candidate')->name("all.candidate");
                Route::get('/download-file/{id}', 'download_file')->name("download.file");
            });

            // Event join Controller
            Route::controller('EventController')->name('events.')->group(function () {
                Route::get('/event-payment/{post}', 'payment')->name("payment");
                Route::get('/event-list', 'lists')->name("lists");



                Route::get('joined-events', 'joined_events')->name("joined.events");




                Route::get('/event-participant/{id}', 'event_participant')->name("participant");
                Route::post('/status', 'postStatus')->name("status");
                Route::get('/download-file/{id}', 'download_file')->name("download.file");
            });

            // User Price Plan
            Route::controller('PricePlanController')->prefix('price-plan')->name('price.plan.')->group(function () {
                Route::get('/', 'index')->name("index");
                Route::get('/{price_plan}', 'insert')->name("insert");
            });

            // User Refill Plan
            Route::controller('RefillPlanController')->prefix('refill-plan')->name('refill.plan.')->group(function () {
                Route::get('/', 'index')->name("index");
                Route::get('/{refill_plan}', 'insert')->name("insert");
            });

            // User Notification
            Route::controller('UserNotificationController')->prefix('notification')->name('notification.')->group(function () {
                Route::get('/', 'index')->name("index");
                Route::get('/read-status/{id}', 'read_status')->name("read.status");
                Route::get('/delete/{id}', 'delete')->name("delete");
            });

            // User Chat
            Route::controller('ChatController')->prefix('chat')->name('chat.')->group(function () {
                Route::post('/', 'store')->name("store");
                Route::get('/download-file/{id}', 'download_file')->name("download.file");
            });






        });

        // Payment
        Route::middleware('registration.complete')->controller('Gateway\PaymentController')->group(function(){
            Route::any('/deposit', 'deposit')->name('deposit');
            Route::post('deposit/insert', 'depositInsert')->name('deposit.insert');
            Route::get('deposit/confirm', 'depositConfirm')->name('deposit.confirm');
            Route::get('deposit/manual', 'manualDepositConfirm')->name('deposit.manual.confirm');
            Route::post('deposit/manual', 'manualDepositUpdate')->name('deposit.manual.update');
        });
    });
});
