<?php

use Illuminate\Support\Facades\Route;

// User Support Ticket
Route::controller('TicketController')->prefix('ticket')->group(function () {
    Route::get('/', 'supportTicket')->name('ticket');
    Route::get('/new', 'openSupportTicket')->name('ticket.open');
    Route::post('/create', 'storeSupportTicket')->name('ticket.store');
    Route::get('/view/{ticket}', 'viewTicket')->name('ticket.view');
    Route::post('/reply/{ticket}', 'replyTicket')->name('ticket.reply');
    Route::post('/close/{ticket}', 'closeTicket')->name('ticket.close');
    Route::get('/download/{ticket}', 'ticketDownload')->name('ticket.download');
});


Route::get('app/deposit/confirm/{hash}', 'Gateway\PaymentController@appDepositConfirm')->name('deposit.app.confirm');

Route::controller('SiteController')->group(function () {
    Route::get('/change/{lang?}', 'changeLanguage')->name('lang');
    Route::get('cookie-policy', 'cookiePolicy')->name('cookie.policy');
    Route::get('/cookie/accept', 'cookieAccept')->name('cookie.accept');
    Route::get('policy/{slug}/{id}', 'policyPages')->name('policy.pages');
    Route::get('placeholder-image/{size}', 'placeholderImage')->name('placeholder.image');

















    Route::get('blog/{slug}/{id}', 'blogDetails')->name('blog.details');
    Route::get('/details/{id}/{slug}', 'postDetails')->name('post.details');
    Route::get('/post/{category_name}/{id}', 'categoryPost')->name('post.category');
    Route::get('/job/post', 'jobPost')->name('post.job');
    Route::get('/events', 'eventPost')->name('post.events');
    Route::get('/popular/post', 'popularPost')->name('post.popular');
    Route::get('/user-profile/{user}', 'user_profile')->name('user.profile.details');
    Route::post('/search', 'User\PostController@search')->name("post.search");

    // Auth User  Route
    Route::middleware('auth')->group(function () {

        Route::get('/post', 'textPost')->name('text.post');
        Route::get('/job', 'addJobPost')->name('add.post.job');
        Route::get('/save-post', 'savePost')->name('save.post');

        // -----------------------post route-----------------------
        Route::controller('User\PostController')->name('post.')->group(function () {
            Route::post('/post-vote', 'post_vote')->name("vote");
            Route::post('/post-bookmark', 'post_bookmark')->name("bookmark");
            Route::post('/post-report', 'post_report')->name("report");
        });


         // -----------------------comment route-----------------------
        Route::controller('User\CommentController')->group(function () {
            Route::post('/comment', 'comment_create')->name("comment");
            Route::post('/comment-edit', 'comment_edit')->name("comment.edit");
            Route::post('/comment-delete', 'comment_delete')->name("comment.delete");
            Route::post('/replay-comment', 'comment_reply')->name("comment.replay");
            Route::post('/comment-vote', 'comment_vote')->name("comment.vote");
            Route::post('/comment-report', 'comment_report')->name("comment.report");
        });
    });

    Route::get('/profile', 'profile')->name('profile');


















    Route::get('maintenance-mode','maintenance')->withoutMiddleware('maintenance')->name('maintenance');
    Route::get('/{slug}', 'pages')->name('pages');
    Route::get('/', 'index')->name('home');
});



