<!--========================== Header section Start ==========================-->
<div class="header-main-area">
    <div class="header" id="header">
        <div class="container-fluid position-relative">
            <div class="row">
                <div class="header-wrapper">
                    <!-- ham menu -->
                    <i class="fa-sharp fa-solid fa-bars-staggered ham__menu" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasExample" aria-controls="offcanvasExample"></i>

                    <!-- logo -->
                    <div class="header-menu-wrapper align-items-center d-flex">
                        <div class="logo-wrapper">
                            <a href="<?php echo e(route('home')); ?>" class="normal-logo" id="normal-logo"> <img
                                    src="<?php echo e(getImage('assets/images/general/logo.png')); ?>" alt=""></a>
                            <a href="<?php echo e(route('home')); ?>" class="dark-logo hidden" id="dark-logo"> <img
                                    src="<?php echo e(getImage('assets/images/general/logo_white.png')); ?>" alt=""></a>
                        </div>
                    </div>
                    <!-- / logo -->

                    <!-- Header Menu -->
                    <div class="menu-wrapper">
                        <ul class="main-menu">
                            <li>
                                <div class="header-search-bar">
                                    <form id="header-search">
                                        <div class="header-search-input">
                                            <input type="text" placeholder="" class="header-form--control"
                                                onkeyup="search(this);">
                                        </div>
                                        <button class="header-search-btn">
                                            <span class="icon">
                                                <i class="fa-solid fa-magnifying-glass"></i>
                                            </span>
                                        </button>
                                    </form>
                                </div>
                                <div class="search-result-box d-none">

                                </div>
                            </li>
                        </ul>
                    </div>
                    <!-- Header Menu /> -->
                    <!-- user actn -->
                    <div class="menu-right-wrapper">
                        <?php if(auth()->guard()->check()): ?>
                            <div class="avatar-thumb">
                                <a href="<?php echo e(route('user.home')); ?>"><img
                                        src="<?php echo e(getImage(getFilePath('userProfile') . '/' . auth()->user()?->image, getFileSize('userProfile'))); ?>"
                                        alt="avatar"></a>
                            </div>
                        <?php endif; ?>

                        <ul>
                            <li class="search-icon">
                                <a href="#" class="login-registration-list__link">
                                    <span class="icon search-icon">
                                        <i class="fa-solid fa-magnifying-glass search-icon"></i>
                                    </span>
                                </a>
                            </li>

                            <!-- < dark option -->
                            <li class="dark-mood-option">
                                <div class="light-dark-btn-wrap ms-1" id="light-dark-checkbox1">
                                    <i class="las la-moon mon-icon"></i>
                                    <i class="las la-sun sun-icon "></i>
                                </div>
                            </li>
                            <!-- dark option /> -->
                            <?php if(auth()->guard()->guest()): ?>
                                <li class="login-registration-list login-icon">
                                    <a href="<?php echo e(route('user.login')); ?>" class="login-registration-list__link">
                                        <span class="icon">
                                            <i class="las la-user-circle mt-1"></i>
                                        </span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <li class="language-box">
                                <i class="fa-solid fa-globe"></i>
                                <div>
                                    <select class="select langSel">
                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($language->code); ?>"
                                                <?php if(Session::get('lang') === $language->code): ?> selected <?php endif; ?>>
                                                <?php echo e(__(ucfirst($language->code))); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <!-- user actn /> -->
                </div>

            </div>
        </div>
    </div>
</div>
<!--========================== Header section End ==========================-->
<?php $__env->startPush('script'); ?>
    <script>
        "use strict"

        function search(object) {
            var searchValue = $(object).val();
            var appendClass = $('.search-result-box');
            if (searchValue != '') {
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('post.search')); ?>",
                    data: {
                        search: searchValue,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(data) {

                        if (data.data != '') {
                            var html = '';
                            $.each(data.data, function(key, item) {
                               var title = slugify(item.title);
                                html +=
                                    `<a href="<?php echo e(url('details/${item.id}/${title}')); ?>" class="search-result-list"
                                        aria-current="true">
                                        <div class="d-flex w-100 justify-content-between">
                                            <h6 class="title">${item.title}</h6>
                                        </div>
                                        <p class="subtitle">${item.content.substring(0, 105)} .....</p>
                                    </a>`;
                            })
                            appendClass.removeClass('d-none').html(html);
                        } else {
                            var html =
                                `
                                    <div class="no-data">
                                        <p>No data found </p>
                                    </div>
                                `;
                            appendClass.removeClass('d-none').html(html);
                        }


                    },
                    error: function(data, status, error) {
                        $.each(data.responseJSON.errors, function(key, item) {
                            notify('error', item);
                        });
                    }
                });
            } else {
                appendClass.addClass('d-none');
            }
            return false;
        }

        function slugify(text) {
            return text.toString().toLowerCase()
                .replace(/\s+/g, '-')
                .replace(/[^\w\-]+/g, '')
                .replace(/\-\-+/g, '-')
                .replace(/^-+/, '')
                .replace(/-+$/, '');
        }
    </script>
    <script>
        (function($) {
            "use strict";
            $(".langSel").on("change", function() {
                window.location.href = "<?php echo e(route('home')); ?>/change/" + $(this).val();
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/presets/default/components/header.blade.php ENDPATH**/ ?>