<div class="sidebar">
    <button class="res-sidebar-close-btn"><i class="fa-solid fa-xmark"></i></button>
    <div class="sidebar__inner">
        <div class="sidebar__logo">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="sidebar__main-logo"><img
                    src="<?php echo e(siteLogo()); ?>" alt="<?php echo app('translator')->get('image'); ?>"></a>
        </div>

        <div class="sidebar__menu-wrapper">
            <ul class="sidebar__menu">
                <li class="sidebar-menu-item <?php echo e(menuActive('admin.dashboard')); ?>">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="nav-link ">
                        <i class="menu-icon fa-solid fa-gauge"></i>
                        <span class="menu-title"><?php echo app('translator')->get('Dashboard'); ?></span>
                    </a>
                </li>

                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('category-management')): ?>
                <li class="sidebar-menu-item <?php echo e(menuActive('admin.category.*')); ?>">
                    <a href="<?php echo e(route('admin.category.index')); ?>" class="nav-link ">
                        <i class="menu-icon fa-solid fa-layer-group"></i>
                        <span class="menu-title"><?php echo app('translator')->get('Categories'); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('plan-management')): ?>
                <li class="sidebar-menu-item <?php echo e(menuActive('admin.price.plan.*')); ?>">
                    <a href="<?php echo e(route('admin.price.plan.index')); ?>" class="nav-link ">
                        <i class="menu-icon fa-solid fa-gift"></i>
                        <span class="menu-title"><?php echo app('translator')->get('Plans'); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('post-management')): ?>
                <li class="sidebar-menu-item sidebar-dropdown <?php echo e(menuActive('admin.posts.*')); ?>">
                    <a href="javascript:void(0)" class="<?php echo e(menuActive('admin.posts.*', 3)); ?>">
                        <i class="menu-icon fa-solid fa-blog"></i>
                        <span class="menu-title"><?php echo app('translator')->get('Posts'); ?></span>
                        <?php if($pendingPostsCount > 0): ?>
                            <div class="blob white"></div>
                        <?php endif; ?>
                    </a>
                    <div class="sidebar-submenu <?php echo e(menuActive('admin.posts.*', 2)); ?> ">
                        <ul>
                            <li class="sidebar-menu-item <?php echo e(menuActive('admin.posts.list')); ?>">
                                <a class="nav-link" href="<?php echo e(route('admin.posts.list')); ?>">
                                    <i class="menu-icon fa-solid fa-circle"></i>
                                    <span class="menu-title"> <?php echo app('translator')->get('All Posts'); ?></span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item <?php echo e(menuActive('admin.posts.active')); ?>">
                                <a class="nav-link" href="<?php echo e(route('admin.posts.active')); ?>">
                                    <i class="menu-icon fa-solid fa-circle"></i>
                                    <span class="menu-title"> <?php echo app('translator')->get('Published Posts'); ?></span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item <?php echo e(menuActive('admin.posts.pending')); ?>">
                                <a class="nav-link" href="<?php echo e(route('admin.posts.pending')); ?>">
                                    <i class="menu-icon fa-solid fa-circle"></i>
                                    <span class="menu-title"> <?php echo app('translator')->get('Unpublished Posts'); ?></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>

                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('job-post-management')): ?>
                <li class="sidebar-menu-item <?php echo e(menuActive('admin.jobs.posts.*')); ?>">
                    <a href="<?php echo e(route('admin.jobs.posts.list')); ?>" class="nav-link ">
                        <i class="menu-icon fa-solid fa-suitcase"></i>
                        <span class="menu-title"><?php echo app('translator')->get('Job Posts'); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('event-post-management')): ?>
                <li class="sidebar-menu-item <?php echo e(menuActive('admin.events.posts.*')); ?>">
                    <a href="<?php echo e(route('admin.events.posts.list')); ?>" class="nav-link ">
                        <i class="menu-icon fa-solid fa-calendar-days"></i>
                        <span class="menu-title"><?php echo app('translator')->get('Event Posts'); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('post-flag-management')): ?>
                <li class="sidebar-menu-item <?php echo e(menuActive('admin.post.comment.*')); ?>">
                    <a href="<?php echo e(route('admin.post.comment.reports')); ?>" class="nav-link ">
                        <i class="menu-icon fa-solid fa-flag"></i>
                        <span class="menu-title"><?php echo app('translator')->get('Post Flags'); ?></span>
                        <?php if(0 < $postCommentReportReadCount): ?>
                            <div class="blob white"></div>
                        <?php endif; ?>
                    </a>
                </li>
                <?php endif; ?>














                <?php if(auth()->guard('admin')->check() && collect(['role', 'staff'])->some(fn($perm) => auth()->guard('admin')->user()->hasPermission($perm))): ?>
                    <li class="sidebar-menu-item sidebar-dropdown <?php echo e(menuActive(['admin.role.*', 'admin.staff.*'])); ?>">
                        <a href="javascript:void(0)" class="<?php echo e(menuActive(['admin.role.*', 'admin.staff.*'], 3)); ?>">
                            <i class="menu-icon fas fa-user-shield"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Staff & Roles'); ?></span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive(['admin.role.*', 'admin.staff.*'], 2)); ?> ">
                            <ul>
                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('role')): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.role.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.role.index')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Roles'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('staff')): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.staff.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.staff.index')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Staffs'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                <?php if(auth()->guard('admin')->check() && collect(['user-management', 'subscriber-management'])->some(fn($perm) => auth()->guard('admin')->user()->hasPermission($perm))): ?>
                    <li
                        class="sidebar-menu-item sidebar-dropdown <?php echo e(menuActive(['admin.users.*', 'admin.subscriber.*'])); ?>">
                        <a href="javascript:void(0)"
                            class="<?php echo e(menuActive(['admin.users.*', 'admin.subscriber.*'], 3)); ?>">
                            <i class="menu-icon fa-regular fa-user"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Users'); ?></span>
                            <?php if($bannedUsersCount > 0 || $emailUnverifiedUsersCount > 0 || $mobileUnverifiedUsersCount > 0 ): ?>
                                <div class="blob white"></div>
                            <?php endif; ?>
                        </a>
                        <div
                            class="sidebar-submenu <?php echo e(menuActive(['admin.users.*', 'admin.subscriber.*'], 2)); ?> ">
                            <ul>
                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('user-management')): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.users.all'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.all')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('All Users'); ?></span>
                                        </a>
                                    </li>

                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.users.notification.all'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.users.notification.all')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Notification to Users'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>


                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('subscriber-management')): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.subscriber.*'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.subscriber.index')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Subscribers'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                <?php if(auth()->guard('admin')->check() && collect(['deposit-management', 'payment-method'])->some(fn($perm) => auth()->guard('admin')->user()->hasPermission($perm))): ?>
                    <li class="sidebar-menu-item sidebar-dropdown <?php echo e(menuActive(['admin.deposit.*', 'admin.gateway.*'])); ?>">
                        <a href="javascript:void(0)" class="<?php echo e(menuActive(['admin.deposit.*', 'admin.gateway.*'], 3)); ?>">
                            <i class="menu-icon fa-solid fa-dollar-sign"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Payments'); ?></span>
                            <?php if(0 < $pendingDepositsCount): ?>
                                <div class="blob white"></div>
                            <?php endif; ?>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive(['admin.deposit.*', 'admin.gateway.*'], 2)); ?> ">
                            <ul>
                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('deposit-management')): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.deposit.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.deposit.log')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Deposits Log'); ?></span>
                                            <?php if(0 < $pendingDepositsCount): ?>
                                                <div class="blob white"></div>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('payment-method')): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.gateway.automatic.index')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.gateway.automatic.index')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Automatic Gateways'); ?></span>
                                        </a>
                                    </li>

                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.gateway.manual.index')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.gateway.manual.index')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Manual Gateways'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                <?php if(auth()->guard('admin')->check() && collect(['withdraw-management', 'withdraw-method'])->some(fn($perm) => auth()->guard('admin')->user()->hasPermission($perm))): ?>
                    <li
                        class="sidebar-menu-item sidebar-dropdown <?php echo e(menuActive(['admin.withdraw.details', 'admin.withdraw.log', 'admin.withdraw.method.*'])); ?>">
                        <a href="javascript:void(0)"
                            class="<?php echo e(menuActive(['admin.withdraw.details', 'admin.withdraw.log', 'admin.withdraw.method.*'], 3)); ?>">
                            <i class="menu-icon fa-regular fa-credit-card"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Withdraw'); ?></span>
                            <?php if(0 < $pendingWithdrawCount): ?>
                                <div class="blob white"></div>
                            <?php endif; ?>
                        </a>
                        <div
                            class="sidebar-submenu <?php echo e(menuActive(['admin.withdraw.details', 'admin.withdraw.log', 'admin.withdraw.method.*'], 2)); ?> ">
                            <ul>
                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('withdraw-management')): ?>
                                    <li
                                        class="sidebar-menu-item <?php echo e(menuActive(['admin.withdraw.details', 'admin.withdraw.log'])); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.withdraw.log')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Withdrawals'); ?></span>
                                            <?php if(0 < $pendingWithdrawCount): ?>
                                                <div class="blob white"></div>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('withdraw-method')): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.withdraw.method.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.withdraw.method.index')); ?>">
                                            <i class="menu-icon fa-solid fa-circle"></i>
                                            <span class="menu-title"><?php echo app('translator')->get('Withdraw Methods'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>



                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('reports')): ?>
                    <li class="sidebar-menu-item sidebar-dropdown <?php echo e(menuActive('admin.report.*')); ?>">
                        <a href="javascript:void(0)" class="<?php echo e(menuActive('admin.report.*', 3)); ?>">
                            <i class="menu-icon fa-solid fa-chart-line"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Reports'); ?></span>
                        </a>
                        <div class="sidebar-submenu <?php echo e(menuActive('admin.report.*', 2)); ?> ">
                            <ul>
                                <li
                                    class="sidebar-menu-item <?php echo e(menuActive(['admin.report.transaction'])); ?>">
                                    <a class="nav-link" href="<?php echo e(route('admin.report.transaction')); ?>">
                                        <i class="menu-icon fa-solid fa-circle"></i>
                                        <span class="menu-title"> <?php echo app('translator')->get('Transactions'); ?></span>
                                    </a>
                                </li>
                                <li
                                    class="sidebar-menu-item <?php echo e(menuActive(['admin.report.login.history', 'admin.report.login.ipHistory'])); ?>">
                                    <a class="nav-link" href="<?php echo e(route('admin.report.login.history')); ?>">
                                        <i class="menu-icon fa-solid fa-circle"></i>
                                        <span class="menu-title"> <?php echo app('translator')->get('Login Activities'); ?></span>
                                    </a>
                                </li>
                                <li class="sidebar-menu-item <?php echo e(menuActive('admin.report.notification.history')); ?>">
                                    <a class="nav-link" href="<?php echo e(route('admin.report.notification.history')); ?>">
                                        <i class="menu-icon fa-solid fa-circle"></i>
                                        <span class="menu-title"> <?php echo app('translator')->get('Notifications'); ?></span>
                                    </a>
                                </li>

                            </ul>
                        </div>
                    </li>
                <?php endif; ?>


                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('support-ticket')): ?>
                    <li class="sidebar-menu-item <?php echo e(menuActive(['admin.ticket.*'])); ?>">
                        <a href="<?php echo e(route('admin.ticket.index')); ?>" class="nav-link ">
                            <i class="menu-icon fa-solid fa-headset"></i>
                            <span class="menu-title"> <?php echo app('translator')->get('Support Ticket'); ?></span>
                            <?php if(0 < $pendingTicketCount): ?>
                                <div class="blob white">
                                </div>
                            <?php endif; ?>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if(auth()->guard('admin')->check() && collect(['website-menu-management', 'section-management', 'page-management'])->some(fn($perm) => auth()->guard('admin')->user()->hasPermission($perm))): ?>
                    <li
                        class="sidebar-menu-item sidebar-dropdown <?php echo e(menuActive(['admin.menu.*', 'admin.frontend.sections*', 'admin.custom.section.index', 'admin.frontend.manage.*'])); ?>">
                        <a href="javascript:void(0)"
                            class="<?php echo e(menuActive(['admin.menu.*', 'admin.frontend.sections*', 'admin.custom.section.index', 'admin.frontend.manage.*'], 3)); ?>">
                            <i class="menu-icon fa-solid fa-bars"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Website Contents'); ?></span>
                        </a>
                        <div
                            class="sidebar-submenu <?php echo e(menuActive(['admin.menu.*', 'admin.frontend.sections*', 'admin.custom.section.index', 'admin.frontend.manage.*'], 2)); ?> ">
                            <ul>
                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('page-management')): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.frontend.manage.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.frontend.manage.pages')); ?>">
                                            <i class="me-1 fa-solid fa-file"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Pages'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('website-menu-management')): ?>
                                    <li class="sidebar-menu-item <?php echo e(menuActive('admin.menu.*')); ?>">
                                        <a class="nav-link" href="<?php echo e(route('admin.menu.index')); ?>">
                                            <i class="me-1 fa-solid fa-bars-staggered"></i>
                                            <span class="menu-title"> <?php echo app('translator')->get('Website Menus'); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>


                <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('settings')): ?>
                    <li
                        class="sidebar-menu-item <?php echo e(menuActive(['admin.setting.index', 'admin.setting.logo.icon', 'admin.setting.notification.*', 'admin.seo', 'admin.setting.cookie', 'admin.setting.custom.css', 'admin.setting.maintenance', 'admin.language.key', 'admin.language.manage', 'admin.plugins.index'])); ?>">
                        <a href="<?php echo e(route('admin.setting.index')); ?>" class="nav-link">
                            <i class="menu-icon fa-solid fa-gear"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Settings'); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <li class="sidebar-menu-item">
                    <span class="nav-link admin__version">
                        <i class="menu-icon fa-solid fa-code-branch"></i>
                         <span class="menu-title"><?php echo app('translator')->get('Panel'); ?> <?php echo e(sysInfo()['admin_version']); ?></span>
                    </span>
                </li>

            </ul>
        </div>
    </div>
</div>



<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            'use strict';
            var $scroll = $('.sidebar__menu-wrapper');

            $('.sidebar-menu-item.active').each(function() {
                var itemPosition = $(this).offset().top - $scroll.offset().top + $scroll.scrollTop() - 110;
                $scroll.animate({
                    scrollTop: itemPosition
                }, 500);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/admin/components/sidenav.blade.php ENDPATH**/ ?>