<?php $__env->startSection('panel'); ?>

    <div class="row gy-4 justify-content-start mb-none-30">
        <div class="col-xxl-3 col-xl-3 col-lg-12">
            <?php echo $__env->make('admin.components.navigate_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <div class="col-xxl-9 col-xl-9 col-lg-12 mb-30">
            <div class="row gy-4">
                <div class="col-md-12 mb-30">
                    <div class="card b-radius--10 ">
                        <div class="card-body p-0">
                            <div class="table-responsive--sm table-responsive">
                                <table class="table table--light style--two custom-data-table">
                                    <thead>
                                        <tr>
                                            <th><?php echo app('translator')->get('Plugin'); ?></th>
                                            <th><?php echo app('translator')->get('Status'); ?></th>
                                            <th><?php echo app('translator')->get('Action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $plugins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plugin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <div class="user">
                                                        <div class="thumb">
                                                            <img src="<?php echo e(getImage(getFilePath('extensions') . '/' . $plugin->image, getFileSize('extensions'))); ?>" alt="<?php echo e(__($plugin->name)); ?>" class="plugin_bg">
                                                        </div>
                                                        <span class="name"><?php echo e(__($plugin->name)); ?></span>
                                                    </div>
                                                </td>

                                                <td>
                                                    <?php echo $plugin->statusBadge; ?>
                                                </td>

                                                <td>
                                                    <div class="d-flex justify-content-end align-items-center gap-2">
                                                        <div class="form-group mb-0">
                                                            <label class="switch m-0"  title="<?php echo app('translator')->get('Change Status'); ?>">
                                                                <input type="checkbox" class="toggle-switch confirmationBtn" data-action="<?php echo e(route('admin.plugins.status', $plugin->id)); ?>"
                                                                data-question="<?php echo app('translator')->get('Are you sure to change plugin status from this system?'); ?>" <?php if($plugin->status): echo 'checked'; endif; ?>>
                                                                <span class="slider round"></span>
                                                            </label>
                                                        </div>

                                                        <button title="<?php echo app('translator')->get('Edit'); ?>" type="button" class="btn btn-sm editBtn" data-name="<?php echo e(__($plugin->name)); ?>" data-shortcode="<?php echo e(json_encode($plugin->shortcode)); ?>" data-action="<?php echo e(route('admin.plugins.update', $plugin->id)); ?>">
                                                            <i class="fa-solid fa-pen-to-square"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Update Plugin'); ?>: <span class="extension-name"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    </button>
                </div>
                <form method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="col-md-12 control-label fw--500"><?php echo app('translator')->get('Script'); ?></label>
                            <div class="col-md-12">
                                <textarea name="script" class="form-control" required rows="8" placeholder="<?php echo app('translator')->get('Paste your script with proper key'); ?>"><?php echo e(old('script')); ?></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100" id="editBtn"><?php echo app('translator')->get('Save Changes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $(document).on('click', '.editBtn', function() {
                var modal = $('#editModal');
                var shortcode = $(this).data('shortcode');

                modal.find('.extension-name').text($(this).data('name'));
                modal.find('form').attr('action', $(this).data('action'));

                var html = '';
                $.each(shortcode, function(key, item) {
                    html += `<div class="form-group">
                        <label class="col-md-12 control-label fw--500">${item.title}</label>
                        <div class="col-md-12">
                            <input name="${key}" class="form-control" placeholder="--" value="${item.value}" required>
                        </div>
                    </div>`;
                })
                modal.find('.modal-body').html(html);

                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/admin/plugins/index.blade.php ENDPATH**/ ?>