<?php $__env->startSection('panel'); ?>
    <div class="row gy-4 justify-content-between mb-3 pb-3">
        <div class="col-xl-4 col-md-6">
            <div class="d-flex flex-wrap justify-content-start w-100">
                <form class="form-inline w-100">
                    <div class="search-input--wrap position-relative">
                        <input type="text" name="search" class="form-control" placeholder="<?php echo app('translator')->get('Search'); ?>..." value="<?php echo e(request()->search ?? ''); ?>">
                        <button class="search--btn position-absolute"><i class="fa fa-search"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="row gy-4">
        <div class="col-md-12 mb-30">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two custom-data-table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('SI'); ?></th>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Credit'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Actions'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="items_table__body">
                                <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e(__($item->name)); ?></td>
                                        <td>
                                            <?php echo e($general->cur_sym); ?><?php echo e(showAmount($item->price, 2)); ?>

                                        </td>
                                        <td>
                                            <?php echo e($item->credit); ?>

                                        </td>
                                        <td>
                                            <?php echo $item->statusBadge; ?>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-end align-items-center gap-2">
                                                <div class="form-group mb-0">
                                                    <label class="switch m-0" title="<?php echo app('translator')->get('Change Status'); ?>">
                                                        <input type="checkbox" class="toggle-switch confirmationBtn" data-action="<?php echo e(route('admin.price.plan.status', $item->id)); ?>"
                                                        data-question="<?php echo app('translator')->get('Are you sure to change category status from this system?'); ?>" <?php if($item->status): echo 'checked'; endif; ?>>
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>

                                                <button title="<?php echo app('translator')->get('Edit'); ?>" type="button" class="btn btn-sm editBtn" data-plan="<?php echo e(json_encode($item->only('name', 'price', 'credit'))); ?>" data-action="<?php echo e(route('admin.price.plan.store', $item->id)); ?>">
                                                    <i class="fa-solid fa-pen-to-square"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div id="pagination-wrapper"  class="pagination__wrapper py-4 <?php echo e($items->hasPages() ? '' : 'd-none'); ?>">
                    <?php if($items->hasPages()): ?>
                    <?php echo e(paginateLinks($items)); ?>

                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>

    
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Plan Management'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    </button>
                </div>
                <form method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label> <?php echo app('translator')->get('Name'); ?></label>
                            <input class="form-control"  name="name" type="text" value="<?php echo e(old('name')); ?>" required>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Price'); ?></label>
                            <input type="text" class="form-control" value="<?php echo e(old('price')); ?>" name="price" required>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Credit'); ?></label>
                            <input type="text" class="form-control" value="<?php echo e(old('credit')); ?>" name="credit" required>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" id="editBtn" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a class="btn btn--primary add__btn" href="javascript:void(0)" data-action="<?php echo e(route('admin.price.plan.store', ['id' => 0])); ?>"><i class="fa-solid fa-plus"></i> <?php echo app('translator')->get('Add New'); ?></a>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            'use strict';

            $(document).on('click', '.editBtn', function() {
                var modal = $('#editModal');
                modal.find('.modal-title').text("<?php echo app('translator')->get('Update Plan Package'); ?>");
                var plan = $(this).data('plan');
                modal.find('input[name=name]').val(plan.name);
                modal.find('input[name=price]').val(plan.price);
                modal.find('input[name=credit]').val(plan.credit);
                modal.find('form').attr('action', $(this).data('action'));
                modal.find('#editBtn').text("<?php echo app('translator')->get('Update'); ?>");
                modal.modal('show');
            });

            $('.add__btn').on('click', function() {
                var modal = $('#editModal');
                modal.find('.modal-title').text("<?php echo app('translator')->get('Add New Plan'); ?>");
                modal.find('input[name=name]').val('');
                modal.find('input[name=price]').val('');
                modal.find('input[name=credit]').val('');
                modal.find('form').attr('action', $(this).data('action'));
                modal.find('#editBtn').text("<?php echo app('translator')->get('Submit'); ?>");
                modal.modal('show');
            });


        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/admin/plan/index.blade.php ENDPATH**/ ?>