<?php $__env->startSection('panel'); ?>
    <div class="row gy-4 justify-content-start mb-none-30">
        <div class="col-xxl-3 col-xl-3 col-lg-12">
            <?php echo $__env->make('admin.components.navigate_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <div class="col-xxl-9 col-xl-9 col-lg-12 mb-30">
            <form action="<?php echo e(route('admin.setting.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row gy-4">
                    <div class="col-xxl-8 col-xl-8">
                        <div class="card bg--white br--solid radius--base p-16">
                            <h5 class="mb-3"><?php echo app('translator')->get('Basic Control'); ?></h5>

                            <div class="row gy-4 mb-4 pb-3">
                                <div class="col-md-6 col-xs-12">
                                    <label class="required"> <?php echo app('translator')->get('Site Title'); ?></label>
                                    <input class="form-control" type="text" name="site_name" required
                                        value="<?php echo e($general->site_name); ?>">
                                </div>
                                <div class="col-md-6 col-xs-12">
                                    <label class="required"><?php echo app('translator')->get('Currency'); ?></label>
                                    <input class="form-control" type="text" name="cur_text" required
                                        value="<?php echo e($general->cur_text); ?>">
                                </div>
                                <div class="col-md-6 col-xs-12">
                                    <label class="required"><?php echo app('translator')->get('Currency Symbol'); ?></label>
                                    <input class="form-control" type="text" name="cur_sym" required
                                        value="<?php echo e($general->cur_sym); ?>">
                                </div>
                                <div class="col-md-6 col-xs-12 time-zone">
                                    <label> <?php echo app('translator')->get('Timezone'); ?></label>
                                    <select class="select2-basic form-control form-select" name="timezone">
                                        <?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>" <?php if($key == $currentTimezone): echo 'selected'; endif; ?>>
                                                <?php echo e(__($timezone)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6 col-xs-12">
                                    <label> <?php echo app('translator')->get('Site Base Color'); ?></label>
                                    <div class="form-group color--select position-relative">
                                        <div class="colorInputWrapper">
                                            <input class="form-control colorPicker" type='text' value="<?php echo e(gs('base_color')); ?>">
                                            <input class="form-control colorCode" name="base_color" type="text" value="<?php echo e(gs('base_color')); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-xs-12">
                                    <label> <?php echo app('translator')->get('Site Secondary Color'); ?></label>
                                    <div class="form-group color--select position-relative">
                                        <div class="colorInputWrapper">
                                            <input class="form-control colorPicker" type='text' value="<?php echo e(gs('secondary_color')); ?>">
                                            <input class="form-control colorCode" name="secondary_color" type="text" value="<?php echo e(gs('secondary_color')); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>






                            <h5 class="mb-3"><?php echo app('translator')->get('Credits'); ?></h5>

                            <div class="row gy-4 mb-4 pb-3">
                                <div class="col-md-6 col-xs-12">
                                    <label class="required"> <?php echo app('translator')->get('Job Posting Cost'); ?><small> (<?php echo app('translator')->get('Credit'); ?>)</small></label>
                                    <input class="form-control" type="text" name="credit" required value="<?php echo e($general->credit); ?>">
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <label class="required"><?php echo app('translator')->get('Event Posting Cost'); ?><small> (<?php echo app('translator')->get('Credit'); ?>)</small></label>
                                    <input class="form-control" type="text" name="event_credit" required value="<?php echo e($general->event_credit); ?>">
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <label class="required"><?php echo app('translator')->get('Upvote Reward Credit'); ?></label>
                                    <input class="form-control" type="text" name="upvote_credit" required value="<?php echo e($general->upvote_credit); ?>">
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <label class="required"><?php echo app('translator')->get('Per Credit Price'); ?></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="per_credit_price"
                                        value="<?php echo e($general->per_credit_price); ?>" />
                                        <span class="input-group-text p-0 border-0">
                                            <span class="input-group-text"><?php echo e(gs()->cur_sym); ?></span>
                                        </span>
                                    </div>
                                </div>
                            </div>




                            <h5 class="mb-3"><?php echo app('translator')->get('Pusher Credentials'); ?></h5>

                            <div class="row gy-4 mb-4 pb-3">
                                <div class="col-md-6 col-xs-12">
                                    <label class="required"> <?php echo app('translator')->get('App ID'); ?><small> (<?php echo app('translator')->get('Credit'); ?>)</small></label>
                                    <input class="form-control" type="text" name="app_id" required value="<?php echo e($general?->pusher_credential?->app_id ?? ''); ?>">
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <label class="required"><?php echo app('translator')->get('App Key'); ?><small> (<?php echo app('translator')->get('Credit'); ?>)</small></label>
                                    <input class="form-control" type="text" name="app_key" required value="<?php echo e($general?->pusher_credential?->app_key ?? ''); ?>">
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <label class="required"><?php echo app('translator')->get('App Secret'); ?></label>
                                    <input class="form-control" type="text" name="app_secret" required value="<?php echo e($general?->pusher_credential?->app_secret ?? ''); ?>">
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <label class="required"><?php echo app('translator')->get('App Cluster'); ?></label>
                                    <input class="form-control" type="text" name="app_cluster" required value="<?php echo e($general?->pusher_credential?->app_cluster ?? ''); ?>">
                                </div>
                                <div class="col-md-6 col-xs-12">
                                    <label class="required"><?php echo app('translator')->get('useTLS'); ?></label>
                                    <select class="form-control form-select" name="useTLS">
                                        <option value="true" <?php if($general?->pusher_credential?->useTLS == 'true'): echo 'selected'; endif; ?>><?php echo app('translator')->get('True'); ?></option>
                                        <option value="false" <?php if($general?->pusher_credential?->useTLS == 'false'): echo 'selected'; endif; ?>><?php echo app('translator')->get('False'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col text-end">
                                    <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Save Changes'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xxl-4 col-xl-4">
                        <div class="card bg--white br--solid radius--base p-16">
                            <h5 class="mb-3"><?php echo app('translator')->get('Control Panel'); ?></h5>
                            <div class="row gy-2">
                                <div class="form-group col-12 d-flex justify-content-between align-items-center">
                                    <label class="fw--500 mb-0"><?php echo app('translator')->get('User Registration'); ?></label>
                                    <label class="switch m-0">
                                        <input type="checkbox" class="toggle-switch" name="registration" <?php echo e($general->registration ? 'checked' : null); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <div class="form-group col-12 d-flex justify-content-between align-items-center">
                                    <label class="fw--500 mb-0"><?php echo app('translator')->get('Email Verification'); ?></label>
                                    <label class="switch m-0">
                                        <input type="checkbox" class="toggle-switch" name="ev" <?php echo e($general->ev ? 'checked' : null); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <div class="form-group col-12 d-flex justify-content-between align-items-center">
                                    <label class="fw--500 mb-0"><?php echo app('translator')->get('Email Notification'); ?></label>
                                    <label class="switch m-0">
                                        <input type="checkbox" class="toggle-switch" name="en" <?php echo e($general->en ? 'checked' : null); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <div class="form-group col-12 d-flex justify-content-between align-items-center">
                                    <label class="fw--500 mb-0"><?php echo app('translator')->get('Mobile Verification'); ?></label>
                                    <label class="switch m-0">
                                        <input type="checkbox" class="toggle-switch" name="sv" <?php echo e($general->sv ? 'checked' : null); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <div class="form-group col-12 d-flex justify-content-between align-items-center">
                                    <label class="fw--500 mb-0"><?php echo app('translator')->get('SMS Notification'); ?></label>
                                    <label class="switch m-0">
                                        <input type="checkbox" class="toggle-switch" name="sn" <?php echo e($general->sn ? 'checked' : null); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <div class="form-group col-12 d-flex justify-content-between align-items-center">
                                    <label class="fw--500 mb-0"><?php echo app('translator')->get('Terms & Condition'); ?></label>
                                    <label class="switch m-0">
                                        <input type="checkbox" class="toggle-switch" name="agree" <?php echo e($general->agree ? 'checked' : null); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <div class="form-group col-12 d-flex justify-content-between align-items-center">
                                    <label class="fw--500 mb-0"><?php echo app('translator')->get('Secure Password'); ?></label>
                                    <label class="switch m-0">
                                        <input type="checkbox" class="toggle-switch" name="secure_password" <?php echo e($general->secure_password ? 'checked' : null); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                                <div class="form-group col-12 d-flex justify-content-between align-items-center mb-0">
                                    <label class="fw--500 mb-0"><?php echo app('translator')->get('Force SSL'); ?></label>
                                    <label class="switch m-0">
                                        <input type="checkbox" class="toggle-switch" name="force_ssl" <?php echo e($general->force_ssl ? 'checked' : null); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/spectrum.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/common/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/spectrum.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.select2-basic').select2({
                dropdownParent: $('.time-zone')
            });

            $('.colorPicker').each(function() {
                let colorInput = $(this).siblings('.colorCode');
                let currentColor = colorInput.val();
                $(this).spectrum({
                    color: `#${currentColor}`,
                    showInput: true,
                    preferredFormat: "hex",
                    change: function(color) {
                        colorInput.val(color.toHex().replace(/^#/, ''));
                    }
                });
            });

            $('.colorCode').on('input', function() {
                let clr = $(this).val().trim();
                let colorPicker = $(this).siblings('.colorPicker');
                if (/^[0-9A-Fa-f]{6}$/.test(clr)) {
                    colorPicker.spectrum("set", `#${clr}`);
                }
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/admin/setting/general.blade.php ENDPATH**/ ?>