
<div class="modal fade" id="postExampleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Post'); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="<?php echo e(route('user.post.store')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group mb-4">
                        <div class="row d-none">
                            <input class="form--control d-none" hidden placeholder="" name="post_type" value="text">
                        </div>

                    </div>
                    <div class="form-group mb-4">
                        <input type="text" class="form-control form--control" id="create-recipient-name"
                            name="title" placeholder="">
                        <label class="form--label" for="create-recipient-name"><?php echo app('translator')->get('Title'); ?></label>
                    </div>

                    <div class="form-group mb-4">
                        <select class="form-select form--control" name="category" required="" id="category">
                            <option value=""><?php echo app('translator')->get('Select Category'); ?></option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>">
                                    <?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <p class="mb-2"><?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>, .<?php echo app('translator')->get('jpeg'); ?>, .<?php echo app('translator')->get('png'); ?>
                        <?php echo app('translator')->get('(max:'); ?> <strong> <?php echo app('translator')->get('2MB)'); ?></strong></p>
                    <div class="form-group mb-4">
                        <input class="form--control" type="file" name="images[]" accept=".png, .jpg, .jpeg" multiple>
                        <label class="form--label"><?php echo app('translator')->get('Image'); ?></label>
                    </div>

                    <div class="form-group mb-4">
                        <textarea class="form--control trumEdit" placeholder="" name="content"></textarea>
                    </div>

                    <div class="form-group text-end">
                        <button type="submit" class="btn btn-primary text-end"><?php echo app('translator')->get('Create'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="jobPostExampleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Job Post'); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="<?php echo e(route('user.post.store')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group mb-4">
                        <div class="row d-none">
                            <input class="form--control d-none" hidden placeholder="" name="post_type" value="job">
                        </div>
                    </div>
                    <div class="form-group mb-4">
                        <input type="text" class="form-control form--control" id="create-recipient-title"
                            name="title" placeholder="">
                        <label class="form--label" for="create-recipient-title"><?php echo app('translator')->get('Title'); ?></label>
                    </div>

                    <div class="form-group mb-4">
                        <select class="form-select form--control" name="category" required="" id="category">
                            <option value=""><?php echo app('translator')->get('Select Category'); ?></option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>">
                                    <?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group mb-4">
                        <input class="form-control form--control" type="date" name="deadline">
                        <label class="form--label"><?php echo app('translator')->get('Deadline'); ?></label>
                    </div>

                    <div class="form-group mb-4">
                        <input class="form-control form--control" type="number" placeholder="" name="vacancy">
                        <label class="form--label"><?php echo app('translator')->get('Vacancy'); ?></label>
                    </div>

                    <div class="form-group mb-4">
                        <div class="form-group">
                            <input class="form--control" placeholder="" type="number" name="salary">
                            <label class="form--label"><?php echo app('translator')->get('Salary Range'); ?></label>
                        </div>
                    </div>

                    <div class="form-group mb-4">
                        <textarea class="form--control trumEdit1" placeholder="" name="content"></textarea>
                    </div>

                    <div class="form-group text-end">
                        <button type="submit" class="btn btn-primary text-end"><?php echo app('translator')->get('Create'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>



<div class="modal fade" id="eventPostExampleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Events'); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="<?php echo e(route('user.post.store')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div class="form-group mb-4">
                        <div class="row d-none">
                            <input class="form--control d-none" hidden placeholder="" name="post_type" value="event">
                        </div>
                    </div>
                    
                    <div class="form-group mb-4">
                        <input type="text" class="form-control form--control" id="create-recipient-title"
                            name="title" placeholder="">
                        <label class="form--label" for="create-recipient-title"><?php echo app('translator')->get('Title'); ?></label>
                    </div>

                    <div class="form-group mb-4">
                        <select class="form-select form--control" name="category" required="" id="category">
                            <option value=""><?php echo app('translator')->get('Select Category'); ?></option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>">
                                    <?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group mb-4">
                        <input class="form-control form--control" type="number" placeholder="" name="fee">
                        <label class="form--label"><?php echo app('translator')->get('Fees'); ?></label>
                    </div>

                    <div class="form-group mb-4">
                        <input class="form-control form--control" type="number" placeholder="" name="participant">
                        <label class="form--label"><?php echo app('translator')->get('Number of Participant'); ?></label>
                    </div>

                    <p class="mb-2"><?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>, .<?php echo app('translator')->get('jpeg'); ?>, .<?php echo app('translator')->get('png'); ?>
                        <?php echo app('translator')->get('(max:'); ?> <strong> <?php echo app('translator')->get('2MB)'); ?></strong></p>
                    <div class="form-group mb-4">
                        <input class="form--control" type="file" name="images[]" accept=".png, .jpg, .jpeg" multiple>
                        <label class="form--label"><?php echo app('translator')->get('Image'); ?></label>
                    </div>

                    <div class="row">
                        <div class="col-sm-6 col-md-6 col-xl-6">
                            <div class="form-group mb-4">
                                <input class="form-control form--control" type="datetime-local" name="start_date">
                                <label class="form--label"><?php echo app('translator')->get('Start Date'); ?></label>
                            </div>
                        </div>

                        <div class="col-sm-6 col-md-6 col-xl-6">
                            <div class="form-group mb-4">
                                <input class="form-control form--control" type="datetime-local" name="end_date">
                                <label class="form--label"><?php echo app('translator')->get('End Date'); ?></label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-4">
                        <textarea class="form--control trumEdit2" placeholder="" name="content"></textarea>
                    </div>

                    <div class="form-group text-end">
                        <button type="submit" class="btn btn-primary text-end"><?php echo app('translator')->get('Create'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/presets/default/components/post-create-modal.blade.php ENDPATH**/ ?>