<?php
    $omenu = App\Models\Menu::where('code', 'others_menu')->latest()->first();
    $othersPages = $omenu->items()->get();
?>
<!--========================== Sidebar mobile menu wrap Start ==========================-->
<div class="offcanvas offcanvas-start text-bg-light" tabindex="-1" id="offcanvasExample">
    <div class="offcanvas-header">
        <div class="logo">
            <div class="header-menu-wrapper align-items-center d-flex">
                <div class="logo-wrapper">
                    <a href="<?php echo e(route('home')); ?>" class="normal-logo" id="offcanvas-logo-normal"> <img
                            src="<?php echo e(getImage('assets/images/general/logo.png')); ?>" alt=""></a>
                    <a href="<?php echo e(route('home')); ?>" class="dark-logo hidden" id="offcanvas-logo-dark"> <img
                            src="<?php echo e(getImage('assets/images/general/logo_white.png')); ?>" alt=""></a>
                </div>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <?php if(auth()->guard()->check()): ?>
            <div class="user-info bg--color">
                <div class="user-thumb">
                    <a href="<?php echo e(route('user.home')); ?>">
                        <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . auth()->user()?->image, getFileSize('userProfile'))); ?>"
                            alt="avatar">
                    </a>
                </div>
                <a href="<?php echo e(route('user.home')); ?>">
                    <h4><?php echo e(auth()->user()->fullname); ?></h4>
                </a>

            </div>
        <?php endif; ?>
        <ul class="side-Nav">
            <?php if(auth()->guard()->guest()): ?>
                <li>
                    <a class="active" href="<?php echo e(route('home')); ?>">
                        <?php echo app('translator')->get('Home'); ?>
                    </a>
                </li>
            <?php endif; ?>
            <?php if(auth()->guard()->check()): ?>
                <li>
                    <a href="<?php echo e(route('user.home')); ?>">

                        <?php echo app('translator')->get('Dashboard'); ?>
                    </a>
                </li>
            <?php endif; ?>

            <li>
                <a href="<?php echo e(route('post.popular')); ?>">
                    <?php echo app('translator')->get('Popular'); ?>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('post.job')); ?>">
                    <?php echo app('translator')->get('Jobs'); ?>
                </a>
            </li>

            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <a href="<?php echo e(route('post.category', [slug($category->name), $category->id])); ?>">
                        <?php echo e(__($category->name)); ?>

                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if(auth()->guard()->check()): ?>
                <li>
                    <a href="<?php echo e(route('save.post')); ?>">

                        <?php echo app('translator')->get('Bookmarks'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.notification.index')); ?>">

                        <?php echo app('translator')->get('Notification'); ?>
                        <?php if($user_notification > 0): ?>
                            <span class="pulse">
                            </span>
                        <?php endif; ?>
                    </a>
                </li>

                <li>
                    <a href="<?php echo e(route('user.price.plan.index')); ?>">

                        <?php echo app('translator')->get('Pricing Plans'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.refill.plan.index')); ?>">
                        <?php echo app('translator')->get('Refill Plan'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.post.job')); ?>">
                        <?php echo app('translator')->get('My Jobs'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.post.applied.jobs')); ?>">
                        <?php echo app('translator')->get('Applied Jobs'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.events.lists')); ?>">
                        <?php echo app('translator')->get('My events'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.events.joined.events')); ?>">
                        <?php echo app('translator')->get('Joined events'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.deposit.history')); ?>">
                        <?php echo app('translator')->get('Deposit Log'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.transactions')); ?>">
                        <?php echo app('translator')->get('Transaction Log'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.withdraw')); ?>">
                        <?php echo app('translator')->get('Withdrawal'); ?>
                    </a>
                </li>

                <li>
                    <a href="<?php echo e(route('user.withdraw.history')); ?>">
                        <?php echo app('translator')->get('Withdraw-Log'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('ticket')); ?>">
                        <?php echo app('translator')->get('Support Ticket'); ?>
                    </a>

                </li>
                <li>
                    <a href="<?php echo e(route('user.profile.setting')); ?>">
                        <?php echo app('translator')->get('Profile Setting'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.change.password')); ?>">
                        <?php echo app('translator')->get('Change Password'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.twofactor')); ?>">

                        <?php echo app('translator')->get('2Fa Security'); ?>
                    </a>
                </li>

            <?php endif; ?>
            <?php if(auth()->guard()->guest()): ?>
                <li>
                    <a href="<?php echo e(route('user.login')); ?>">
                        <?php echo app('translator')->get('Login'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('user.register')); ?>">
                        <?php echo app('translator')->get('Signup'); ?>
                    </a>
                </li>

            <?php endif; ?>




            <?php if($othersPages): ?>
                <?php $__currentLoopData = $othersPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($data->link_type == 2): ?>
                    <li>
                        <a href="<?php echo e($data->url ?? ''); ?>" target="_blank">
                            <?php echo e(__($data->title)); ?>

                        </a>
                    </li>
                    <?php else: ?>
                    <li>
                        <a href="<?php echo e(route('pages',[$data->url])); ?>">
                            <?php echo e(__($data->title)); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>


            <?php if(auth()->guard()->check()): ?>
                <li>
                    <a href="<?php echo e(route('user.logout')); ?>">
                        <?php echo app('translator')->get('Log Out'); ?>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</div>

<!--========================== Sidebar mobile menu wrap End ==========================-->
<?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/presets/default/components/sidenav.blade.php ENDPATH**/ ?>