<?php
    $hmenu = App\Models\Menu::where('code', 'left_sidemenu')->first();
    $pages = $hmenu->items()->get();

    $omenu = App\Models\Menu::where('code', 'others_menu')->latest()->first();
    $othersPages = $omenu->items()->get();
?>
<!-- left side -->
<div class="col-lg-3">
    <aside class="leftside-bar">
        <!-- menu-item-wraper -->
        <div class="menu-item-wraper">
            <div class="nav-menu">
                <div class="navmenu-item-wraper">
                    <?php if($pages): ?>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($data->link_type == 2): ?>
                                <a href="<?php echo e($data->url ?? ''); ?>" target="_blank" class="menu-item">
                                    <?php echo  $data->icon ; ?>
                                    <h6 class="menu-name"><?php echo e(__($data->title)); ?></h6>
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('pages',[$data->url])); ?>" class="menu-item">
                                    <?php echo  $data->icon ; ?>
                                    <h6 class="menu-name <?php echo e(route('pages',[$data->url]) == url()->current() ? 'active' : null); ?>"><?php echo e(__($data->title)); ?></h6>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('save.post')); ?>" class="menu-item">
                        <i class="fa-solid fa-bookmark"></i>
                        <h6 class="menu-name <?php echo e(menuActive('save.post')); ?>"><?php echo app('translator')->get('Bookmarks'); ?></h6>
                    </a>
                    <?php endif; ?>

                </div>
            </div>
            <!-- menu-item-wraper / -->
            <!-- latest-topics-menu -->
            <div class="latest-topics-menu">
                <div class="latest-topics-wraper">
                    <h6 class="menu-title"><?php echo app('translator')->get('TOPICS'); ?></h6>
                    <div class="latest-topics-list">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($loop->iteration > 0 && $loop->iteration <= 4): ?>
                                <a href="<?php echo e(route('post.category', [slug($category->name), $category->id])); ?>"
                                    class="menu-item">
                                    <?php echo  $category->icon ; ?>
                                    <h6
                                        class="menu-name <?php echo e(url()->current() == route('post.category', [slug($category->name), $category->id]) ? 'active' : ''); ?>">
                                        <?php echo e($category->name); ?></h6>
                                </a>
                            <?php endif; ?>
                            <?php if($loop->iteration > 4): ?>
                                <div class="show-all-menu-wraper">
                                    <div class="show-all-menu-item">
                                        <a href="<?php echo e(route('post.category', [slug($category->name), $category->id])); ?>"
                                            class="menu-item">
                                            <?php echo  $category->icon ; ?>
                                            <h6 class="menu-name"><?php echo e($category->name); ?></h6>
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <div class="menu-item">
                            <button class="show-all-tgl-btn"><?php echo app('translator')->get('See More'); ?></button>
                        </div>

                    </div>
                </div>
            </div>
            <!-- latest-topics-menu / -->

            <!-- others-menu -->
            <div class="others-menu">
                <div class="others-item-wraper">
                    <h6 class="menu-title"><?php echo app('translator')->get('Others'); ?></h6>
                    <?php if($othersPages): ?>
                        <?php $__currentLoopData = $othersPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($k == 0): ?>
                            <div class="others-item-list">
                            <?php endif; ?>
                            <?php if($data->link_type == 2): ?>
                                <a href="<?php echo e($data->url ?? ''); ?>" target="_blank" class="menu-item">
                                    <?php echo  $data->icon ; ?>
                                    <h6 class="menu-name"><?php echo e(__($data->title)); ?></h6>
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('pages',[$data->url])); ?>" class="menu-item">
                                     <?php echo  $data->icon ; ?>
                                    <h6 class="menu-name <?php echo e(route('pages',[$data->url]) == url()->current() ? 'active' : null); ?>"><?php echo e(__($data->title)); ?></h6>
                                </a>
                            <?php endif; ?>
                            <?php if($k == 0): ?>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
            <!-- others-menu /-->

            <div class="copy-right-text text-center ps-5 mt-4">
                <p class="bottom-footer-text"> &copy; <?php echo app('translator')->get('Copyright'); ?> <?php echo e(now()->year); ?> <?php echo app('translator')->get('. All rights reserved.'); ?></p>
            </div>
        </div>
    </aside>
</div>
<!-- left side / -->
<?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/presets/default/components/leftside.blade.php ENDPATH**/ ?>