<?php $__env->startSection('panel'); ?>

    <div class="row gy-4 pb-4 mb-2">
        <div class="col-sm-6 col-xxl-3 col-xl-3">
            <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.withdraw.log', ['status' => 'all'])); ?>">
                <div class="dashboard-widget__icon">
                    <i class="dashboard-card-icon fa-solid fa-dollar-sign"></i>
                </div>
                <div class="dashboard-widget__content">
                    <span class="title"><?php echo app('translator')->get('Withdrawals Requests'); ?></span>
                    <h5 class="number"><?php echo e($logCount); ?></h5>
                </div>
                <span class="arrow--btn position-absolute"><i class="fa-solid fa-chevron-right"></i></span>
            </a>
        </div>

        <div class="col-sm-6 col-xxl-3 col-xl-3">
            <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.withdraw.log', ['status' => 'approved'])); ?>">
                <div class="dashboard-widget__icon">
                    <i class="dashboard-card-icon fa-solid fa-check-to-slot"></i>
                </div>
                <div class="dashboard-widget__content">
                    <span class="title"><?php echo app('translator')->get('Approved Withdrawals'); ?></span>
                    <h5 class="number"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($successful)); ?></h5>
                </div>
                <span class="arrow--btn position-absolute"><i class="fa-solid fa-chevron-right"></i></span>
            </a>
        </div>


        <div class="col-sm-6 col-xxl-3 col-xl-3">
            <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.withdraw.log', ['status' => 'pending'])); ?>">
                <div class="dashboard-widget__icon">
                    <i class="dashboard-card-icon fa-solid fa-hourglass-half"></i>
                </div>
                <div class="dashboard-widget__content">
                    <span class="title"><?php echo app('translator')->get('Pending Withdrawals'); ?></span>
                    <h5 class="number"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($pending)); ?></h5>
                </div>
                <span class="arrow--btn position-absolute"><i class="fa-solid fa-chevron-right"></i></span>
            </a>
        </div>

        <div class="col-sm-6 col-xxl-3 col-xl-3">
            <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.withdraw.log', ['status' => 'rejected'])); ?>">
                <div class="dashboard-widget__icon">
                    <i class="dashboard-card-icon fa-solid fa-ban"></i>
                </div>
                <div class="dashboard-widget__content">
                    <span class="title"><?php echo app('translator')->get('Rejected Withdrawals'); ?></span>
                    <h5 class="number"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($rejected)); ?></h5>
                </div>
                <span class="arrow--btn position-absolute"><i class="fa-solid fa-chevron-right"></i></span>
            </a>
        </div>


    </div>


    <div class="row gy-4 justify-content-between mb-3 pb-3">
        <div class="col-lg-5">

                <form>
                    <div class="row gy-4">
                        <div class="col-lg-6">
                            <div class="search-input--wrap position-relative w-100">
                                <input type="search" name="search" class="form-control" placeholder="<?php echo app('translator')->get('Search by username'); ?>"
                                    value="<?php echo e(request()->search); ?>">
                                <button class="search--btn position-absolute" type="submit"><i class="fa fa-search"></i></button>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="search-input--wrap position-relative w-100">
                                <input name="date" type="text" data-range="true" data-multiple-dates-separator=" - " data-language="en" class="datepicker-here form-control" data-position='bottom right' placeholder="<?php echo app('translator')->get('Date from - to'); ?>" autocomplete="off" value="<?php echo e(request()->date); ?>">
                                <button class="search--btn position-absolute" type="submit"><i class="fa fa-search"></i></button>
                            </div>
                        </div>
                    </div>
                </form>

        </div>

        <div class="col-xl-2 col-lg-6">
            <div class="d-flex align-items-center justify-content-end gap-2">
                <select id="table__data__filter" name="status" class="form-control form-select bg--transparent outline">
                    <option value="all"><?php echo app('translator')->get('All'); ?></option>
                    <option value="approved"><?php echo app('translator')->get('Approved'); ?></option>
                    <option value="pending"><?php echo app('translator')->get('Pending'); ?></option>
                    <option value="rejected"><?php echo app('translator')->get('Rejected'); ?></option>
                </select>
            </div>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Gateway'); ?>||<?php echo app('translator')->get('Trx'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?>||<?php echo app('translator')->get('Charge'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Requested at'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>

                                </tr>
                            </thead>
                            <tbody id="items_table__body">
                                <?php echo $__env->make('admin.components.tables.withdraw_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>


                <div id="pagination-wrapper"  class="pagination__wrapper py-4 <?php echo e($items->hasPages() ? '' : 'd-none'); ?>">
                    <?php if($items->hasPages()): ?>
                    <?php echo e(paginateLinks($items)); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/datepicker.min.css')); ?>">
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/common/js/datepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/common/js/datepicker.en.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('style'); ?>
    <style>
        .nav-tabs {
            border: 0;
        }

        .nav-tabs li a {
            border-radius: 4px !important;
        }
    </style>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            'use strict';

            if (!$('.datepicker-here').val()) {
                $('.datepicker-here').datepicker();
            }

            let baseUrl = `<?php echo e(route('admin.withdraw.log', ':status')); ?>`;

            $('#table__data__filter').on('change', function () {
                let status = $(this).val();
                let url = baseUrl.replace(':status', status);


                $.ajax({
                    url: url,
                    method: 'GET',
                    data: {
                        search: $('#search-box').val()
                    },
                    beforeSend: function () {
                        $('#items_table__body').html('<tr><td colspan="6"><?php echo app('translator')->get("Loading"); ?>...</td></tr>');
                    },
                    success: function (response) {
                        $('#items_table__body').html(response.html);
                        $('.card-footer').html(response.pagination);

                        if ($.trim(response.pagination) === '') {
                            $('#pagination-wrapper').addClass('d-none');
                        } else {
                            $('#pagination-wrapper').removeClass('d-none');
                        }
                    },
                    error: function () {
                        alert('Failed to load filtered tickets.');
                    }
                });
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/admin/withdraw/withdrawals.blade.php ENDPATH**/ ?>