<div id="confirmationModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Confirmation Alert!'); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                </button>
            </div>
            <form action="" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <p class="question"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                    <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Yes'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>

<script>
    (function ($) {
        "use strict";
        $(document).on('click','.confirmationBtn', function () {
            var modal   = $('#confirmationModal');
            let data    = $(this).data();
            modal.find('.question').text(`${data.question}`);
            modal.find('form').attr('action', `${data.action}`);
            modal.modal('show');
        });

        $(document).on('change', '.confirmationBtn', function (e) {
            e.preventDefault();

            let checkbox = $(this);
            let isChecked = checkbox.is(':checked');

            // Revert the state until confirmed
            checkbox.prop('checked', !isChecked);

            var modal = $('#confirmationModal');
            let data = checkbox.data();

            modal.find('.question').text(`${data.question}`);
            modal.find('form').attr('action', `${data.action}`);

            // Save the clicked checkbox reference inside modal
            modal.data('checkbox', checkbox);
            modal.data('checked', isChecked);

            modal.modal('show');
        });


        $('#confirmationModal form').on('submit', function (e) {
            let modal = $('#confirmationModal');
            let checkbox = modal.data('checkbox');
            let shouldBeChecked = modal.data('checked');

            checkbox.prop('checked', shouldBeChecked);

            return true;
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/components/confirmation-modal.blade.php ENDPATH**/ ?>