<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"
            $(".post_vote").on('click', function() {
                var auth = <?php echo json_encode(auth()->check(), 15, 512) ?>;
                if (auth) {
                    var url = "<?php echo e(route('post.vote')); ?>";
                    var token = '<?php echo e(csrf_token()); ?>';
                    var id = $(this).data("post-id");
                    var data = {
                        post_id: id,
                        vote: $(this).data("post-vote"),
                        _token: token
                    }
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: data,
                        success: function(data) {
                            $(".total_post_vote" + id).find('h6').text(data);
                        },
                        error: function(data, status, error) {
                            $.each(data.responseJSON.errors, function(key, item) {
                                notify('error', item);
                            });

                        }
                    });
                } else {
                    window.location.href = "<?php echo e(route('user.login')); ?>";
                }
            });

            $(".bookmark-button").on('click', function() {
                var auth = <?php echo json_encode(auth()->check(), 15, 512) ?>;
                if (auth) {
                    var url = "<?php echo e(route('post.bookmark')); ?>";
                    var token = '<?php echo e(csrf_token()); ?>';
                    var id = $(this).data("post-id");
                    var this_data = $(this);
                    var data = {
                        post_id: id,
                        _token: token
                    }
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: data,
                        success: function(data) {
                            if (data.status && data.status == "saved") {
                                this_data.addClass("active-bookmark");
                                var icon = this_data.find("i");
                                if (icon.hasClass("fa-solid")) {
                                    icon.removeClass("fa-solid")
                                        .addClass("fa-regular");
                                } else {
                                    icon.removeClass("fa-regular")
                                        .addClass("fa-solid");
                                }
                                notify('success', data.message);
                            } else {
                                this_data.removeClass("active-bookmark");
                                var icon = this_data.find("i");
                                if (icon.hasClass("fa-solid")) {
                                    icon.removeClass("fa-solid")
                                        .addClass("fa-regular");
                                } else {
                                    icon.removeClass("fa-regular")
                                        .addClass("fa-solid");
                                }
                                notify('success', data.message);
                            }
                        },
                        error: function(data, status, error) {
                            $.each(data.responseJSON.errors, function(key, item) {
                                notify('error', item);
                            });
                        }
                    });
                } else {
                    $(".toast-container").addClass('d-none');
                    window.location.href = "<?php echo e(route('user.login')); ?>";
                }
            });

            $(".report_button").on('click', function() {
                var auth = <?php echo json_encode(auth()->check(), 15, 512) ?>;
                if (auth) {
                    var id = $(this).data("post-id");
                    $(".set-modal-post-id").val(id);
                    $(".report_modal").modal('show');
                } else {
                    window.location.href = "<?php echo e(route('user.login')); ?>";
                }
            });

            $("form#report_form").on('submit', function(event) {
                event.preventDefault();
                var reason = $(".reason").val();
                var id = $(".set-modal-post-id").val();
                var url = "<?php echo e(route('post.report')); ?>";
                var token = '<?php echo e(csrf_token()); ?>';
                var this_data = $(this);
                var data = {
                    reason: reason,
                    post_id: id,
                    _token: token
                }
                $.ajax({
                    type: "POST",
                    url: url,
                    data: data,
                    success: function(data) {
                        $(".report_modal").modal('hide');
                        $(".reason").val('');
                        notify(data.status, data.message);
                    },
                    error: function(data, status, error) {
                        $.each(data.responseJSON.errors, function(key, item) {
                            notify('error', item);
                        });
                    }
                });
            })
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/presets/default/common/post-vote-report-js.blade.php ENDPATH**/ ?>