<?php if(auth()->guard('admin')->check() && collect(['settings', 'plugin-management', 'language-management'])->some(fn($perm) => auth()->guard('admin')->user()->hasPermission($perm))): ?>
<div class="card bg--white br--solid radius--base p-16">
    <h5 class="mb-3"><?php echo app('translator')->get('Navigate To'); ?></h5>
    <ul class="general-navigate--bar d-flex flex-xl-column flex-wrap justify-content-start">
        <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('settings')): ?>
        <li>
            <a href="<?php echo e(route('admin.setting.index')); ?>" class="<?php echo e(menuActive('admin.setting.index')); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-solid fa-sliders"></i>
                <h6><?php echo app('translator')->get('Basic Settings'); ?></h6>
            </a>
        </li>
        <li>
            <a href="<?php echo e(route('admin.setting.logo.icon')); ?>" class="<?php echo e(menuActive('admin.setting.logo.icon')); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-solid fa-images"></i>
                <h6><?php echo app('translator')->get('Logo & Favicon'); ?></h6>
            </a>
        </li>

        <li>
            <a href="<?php echo e(route('admin.setting.notification.templates')); ?>" class="<?php echo e(menuActive('admin.setting.notification.templates')); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-regular fa-bell"></i>
                <h6><?php echo app('translator')->get('Email & Notification'); ?></h6>
            </a>
        </li>

        <li>
            <a href="<?php echo e(route('admin.seo')); ?>" class="<?php echo e(menuActive('admin.seo')); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-solid fa-bullseye"></i>
                <h6><?php echo app('translator')->get('SEO'); ?></h6>
            </a>
        </li>

        <li>
            <a href="<?php echo e(route('admin.setting.cookie')); ?>" class="<?php echo e(menuActive('admin.setting.cookie')); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-regular fa-circle-check"></i>
                <h6><?php echo app('translator')->get('GDPR Policy'); ?></h6>
            </a>
        </li>

        <li>
            <a href="<?php echo e(route('admin.setting.custom.css')); ?>" class="<?php echo e(menuActive('admin.setting.custom.css')); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-regular fa-file-code"></i>
                <h6><?php echo app('translator')->get('Custom CSS'); ?></h6>
            </a>
        </li>

        <li>
            <a href="<?php echo e(route('admin.setting.maintenance')); ?>" class="<?php echo e(menuActive('admin.setting.maintenance')); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-solid fa-screwdriver-wrench"></i>
                <h6><?php echo app('translator')->get('Maintenance'); ?></h6>
            </a>
        </li>
        <?php endif; ?>

        <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('plugin-management')): ?>
        <li>
            <a href="<?php echo e(route('admin.plugins.index')); ?>" class="<?php echo e(menuActive('admin.plugins.index')); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-solid fa-puzzle-piece"></i>
                <h6><?php echo app('translator')->get('Plugins'); ?></h6>
            </a>
        </li>
        <?php endif; ?>
        <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('language-management')): ?>
        <li>
            <a href="<?php echo e(route('admin.language.manage')); ?>" class="<?php echo e(menuActive(['admin.language.*'])); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-solid fa-language"></i>
                <h6><?php echo app('translator')->get('Language'); ?></h6>
            </a>
        </li>
        <?php endif; ?>

        <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('settings')): ?>
        <li>
            <a href="<?php echo e(route('admin.setting.socialite.credentials')); ?>"
                class="<?php echo e(menuActive('admin.setting.socialite.credentials')); ?> d-flex align-items-center justify-content-start gap-2">
                <i class="fa-solid fa-users-gear"></i>
                <h6><?php echo app('translator')->get('Social Credentials'); ?></h6>
            </a>
        </li>
        <?php endif; ?>

    </ul>
</div>
<?php endif; ?>
<?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/admin/components/navigate_sidebar.blade.php ENDPATH**/ ?>