<?php $__env->startSection('panel'); ?>

    <?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('dashboard')): ?>

        <?php if(isset($general->system_info) && !empty(json_decode($general->system_info)->message)): ?>
            <?php if(json_decode($general->system_info)->message): ?>
            <div class="row">
                <?php $__currentLoopData = json_decode($general->system_info)->message; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-12">
                        <div class="alert border border--primary" role="alert">
                            <div class="alert__icon bg--primary"><i class="far fa-bell"></i></div>
                            <p class="alert__message"><?php echo $msg; ?></p>
                            <button type="button" class="close" data-bs-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endif; ?>
        <?php endif; ?>

        <div class="row gy-4">
            <div class="col-xl-12">

                <div class="row gy-4">
                    <div class="col-xxl-3 col-xl-4 col-md-6">
                        <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.users.all', 'active')); ?>">
                            <div class="dashboard-widget__icon">
                                <i class="dashboard-card-icon fa-solid fa-user-check"></i>
                            </div>
                            <div class="dashboard-widget__content">
                                <span class="title"><?php echo app('translator')->get('Verified Users'); ?></span>
                                <h5 class="number"><?php echo e($widget['verified_users']); ?></h5>
                            </div>
                            <span class="badge badge--success position-absolute">
                                <i class="fa-solid fa-arrow-trend-up"></i> +<?php echo e($widget['verified_percent']); ?>%
                            </span>
                        </a>
                    </div>

                    <div class="col-xxl-3 col-xl-4 col-md-6">
                        <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.users.all', 'banned')); ?>">

                            <div class="dashboard-widget__icon">
                                <i class="dashboard-card-icon fa-solid fa-ban"></i>
                            </div>

                            <div class="dashboard-widget__content">
                                <span class="title"><?php echo app('translator')->get('Banned Users'); ?></span>
                                <h5 class="number"><?php echo e($widget['banned_users']); ?></h5>
                            </div>

                            <span class="badge badge--danger position-absolute">
                                <i class="fa-solid fa-arrow-trend-down"></i><?php echo e($widget['banned_percent']); ?>%
                            </span>
                        </a>
                    </div>

                    <div class="col-xxl-3 col-xl-4 col-md-6">
                        <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.users.all', 'email_unverified')); ?>">
                            <div class="dashboard-widget__icon">
                                <i class="dashboard-card-icon fa-solid fa-envelope-open-text"></i>
                            </div>
                            <div class="dashboard-widget__content">
                                <span class="title"><?php echo app('translator')->get('Email Unverified'); ?></span>
                                <h5 class="number"><?php echo e($widget['email_unverified_users']); ?></h5>
                            </div>
                            <span class="badge badge--success position-absolute">
                                <i class="fa-solid fa-arrow-trend-up"></i> + <?php echo e($widget['email_unverified_percent']); ?>%
                            </span>
                        </a>
                    </div>

                    <div class="col-xxl-3 col-xl-4 col-md-6">
                        <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.users.all', 'mobile_unverified')); ?>">

                            <div class="dashboard-widget__icon">
                                <i class="dashboard-card-icon fa-solid fa-mobile-screen-button"></i>
                            </div>

                            <div class="dashboard-widget__content">
                                <span class="title"><?php echo app('translator')->get('Mobile Unverified'); ?></span>
                                <h5 class="number"><?php echo e($widget['mobile_unverified_users']); ?></h5>
                            </div>

                            <span class="badge badge--success position-absolute"><i class="fa-solid fa-arrow-trend-up"></i> +<?php echo e($widget['mobile_unverified_percent']); ?>%</span>
                        </a>
                    </div>

                    <div class="col-xxl-3 col-xl-4 col-md-6">
                        <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.deposit.log')); ?>">
                            <div class="dashboard-widget__icon">
                                <i class="dashboard-card-icon fa-solid fa-hand-holding-dollar"></i>
                            </div>
                            <div class="dashboard-widget__content">
                                <span class="title"><?php echo app('translator')->get('Total Deposit'); ?></span>
                                <h5 class="number"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($widget['total_deposit_amount'], 2)); ?></h5>
                            </div>
                        </a>
                    </div>

                    <div class="col-xxl-3 col-xl-4 col-md-6">
                        <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.deposit.log')); ?>">

                            <div class="dashboard-widget__icon">
                                <i class="dashboard-card-icon fa-solid fa-circle-dollar-to-slot"></i>
                            </div>

                            <div class="dashboard-widget__content">
                                <span class="title"><?php echo app('translator')->get('Deposit Charge'); ?></span>
                                <h5 class="number"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($widget['deposit_change'], 2)); ?></h5>
                            </div>
                        </a>
                    </div>

                    <div class="col-xxl-3 col-xl-4 col-md-6">
                        <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.withdraw.log')); ?>">
                            <div class="dashboard-widget__icon">
                                <i class="dashboard-card-icon fa-solid fa-sack-dollar"></i>
                            </div>
                            <div class="dashboard-widget__content">
                                <span class="title"><?php echo app('translator')->get('Total Withdraw'); ?></span>
                                <h5 class="number"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($widget['total_withdraw_amount'], 2)); ?></h5>
                            </div>
                        </a>
                    </div>

                    <div class="col-xxl-3 col-xl-4 col-md-6">
                        <a class="dashboard-widget--card position-relative" href="<?php echo e(route('admin.withdraw.log')); ?>">
                            <div class="dashboard-widget__icon">
                                <i class="dashboard-card-icon fa-solid fa-dollar-sign"></i>
                            </div>

                            <div class="dashboard-widget__content">
                                <span class="title"><?php echo app('translator')->get('Withdraw Charge'); ?></span>
                                <h5 class="number"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($widget['withdraw_change'], 2)); ?></h5>
                            </div>
                        </a>
                    </div>
                </div>
            </div>




            <div class="col-xl-6">
                <div class="card bg--white br--solid">
                    <div class="card-body position-relative">
                        <div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-3">
                            <h5 class="card-title mb-0"><?php echo app('translator')->get('Monthly Deposit & Withdraw Report'); ?></h5>
                        </div>
                        <div id="account-chart" data-withdrawals="<?php echo e(base64_encode(json_encode($withdrawalsChart))); ?>" data-deposits="<?php echo e(base64_encode(json_encode($depositsChart))); ?>"></div>
                    </div>
                </div>
            </div>

            <div class="col-xl-6">
                <div class="card bg--white br--solid">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-3">
                            <h5 class="card-title mb-0"><?php echo app('translator')->get('Recent Transactions'); ?></h5>
                        </div>
                        <div class="table-responsive table-responsive--sm">
                            <table class="table align-items-center style--three table--light">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('Customer'); ?></th>
                                        <th><?php echo app('translator')->get('Trx'); ?></th>
                                        <th><?php echo app('translator')->get('Date'); ?></th>
                                        <th><?php echo app('translator')->get('Amount'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="user--td">
                                            <div class="d-flex justify-content-between justify-content-lg-start gap-3">
                                                <div class="user--info d-flex gap-3 flex-shrink-0 align-items-center flex-wrap flex-md-nowrap">
                                                    <div class="user--thumb">
                                                        <?php if(!empty($trx->user->image)): ?>
                                                            <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . $trx?->user?->image )); ?>" alt="<?php echo app('translator')->get('Image'); ?>">
                                                        <?php else: ?>
                                                            <img src="<?php echo e(getImage('assets/images/general/avatar.png')); ?>" alt="<?php echo app('translator')->get('Image'); ?>">
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="user--content">
                                                        <a class="text-start" href="<?php echo e(route('admin.report.transaction') . '?search=' . $trx->user->username); ?>">
                                                            <?php echo e($trx->user->fullname); ?>

                                                        </a>
                                                        <p class="text-start"><?php echo e($trx?->user?->email); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            <?php echo e($trx->trx); ?>

                                        </td>

                                        <td>
                                            <h6><?php echo e(showDateTime($trx->created_at, 'd M Y')); ?></h6>
                                        </td>
                                        <td>
                                            <h6><?php echo e(showAmount($trx->post_balance)); ?> <?php echo e(__($general->cur_text)); ?></h6>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>



            <div class="col-xl-9 col-md-8">
                <div class="card bg--white br--solid">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-3">
                            <h5 class="card-title mb-0"><?php echo app('translator')->get('Recent Support Tickets'); ?></h5>
                        </div>

                        <div class="table-responsive table-responsive--sm">
                            <table class="table align-items-center style--three table--light">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('Customer'); ?></th>
                                        <th><?php echo app('translator')->get('Subject'); ?></th>
                                        <th><?php echo app('translator')->get('Priority'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex flex-wrap flex-md-nowrap justify-content-end justify-content-lg-start align-items-center gap-2">
                                                <div class="user--thumb">
                                                    <?php if(!empty($ticket->user->image)): ?>
                                                        <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . $ticket?->user?->image )); ?>" alt="<?php echo app('translator')->get('Image'); ?>">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(getImage('assets/images/general/avatar.png')); ?>" alt="<?php echo app('translator')->get('Image'); ?>">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="user--content">
                                                    <?php if($ticket->user_id): ?>
                                                    <a class="text-start" href="<?php echo e(route('admin.users.detail', $ticket->user->id)); ?>">
                                                        <?php echo e($ticket->user->fullname); ?>

                                                    </a>
                                                    <p class="text-start"><?php echo e($ticket?->user?->email); ?></p>
                                                    <?php else: ?>

                                                    <p class="text-start"><?php echo e($ticket?->name); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            <a href="<?php echo e(route('admin.ticket.view', $ticket->id)); ?>" class="fw--500">
                                                <?php echo app('translator')->get('Ticket'); ?>#<?php echo e($ticket->ticket); ?> - <?php echo e(strLimit($ticket->subject,15)); ?>

                                            </a>
                                        </td>

                                        <td>
                                            <?php echo $ticket->priorityBadge; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                    <?php endif; ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-xl-3 col-md-4">
                <div class="card bg--white br--solid">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-3">
                            <h5 class="card-title mb-0"><?php echo app('translator')->get('Transactions'); ?></h5>
                        </div>

                        <div class="d-flex justify-content-center align-items-center gap-5 py-4">
                            <div class="order-info--item d-flex gap-4 flex-column justify-content-center align-items-center">
                                <div class="d-flex flex-column justify-content-center align-items-center gap-2">
                                    <div class="number--wrap one d-flex justify-content-center align-items-center flex-shrink-0">
                                        <h2 class="m-0 text--white"><?php echo e(getAmount($widget['plus_transactions'])); ?></h2>
                                    </div>
                                    <p class="fs-6"><?php echo app('translator')->get('Plus Transactions'); ?></p>
                                </div>
                                <div class="d-flex flex-column justify-content-center align-items-center gap-2">
                                    <div class="number--wrap two d-flex justify-content-center align-items-center flex-shrink-0">
                                        <h2 class="m-0 text--white"><?php echo e(getAmount($widget['minus_transactions'])); ?></h2>
                                    </div>
                                    <p class="fs-6"><?php echo app('translator')->get('Minus Transactions'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    <?php else: ?>
        <div class="row">
            <div class="col-lg-12">
                <p><?php echo app('translator')->get('You have no permission to view the page content!'); ?></p>
            </div>
        </div>

    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php if(auth()->guard('admin')->check() && auth()->guard('admin')->user()->hasPermission('dashboard')): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/admin/js/apexcharts.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('script'); ?>
        <script>
            (function ($) {
                'use strict';

                const $chartData = $('#account-chart');
                const withdrawalsEncoded = $chartData.data('withdrawals');
                const depositsEncoded = $chartData.data('deposits');

                const withdrawalsChart = JSON.parse(atob(withdrawalsEncoded));
                const depositsChart = JSON.parse(atob(depositsEncoded));

                var options = {
                    chart: {
                        type: 'bar',
                        stacked: false,
                        height: '333px'
                    },
                    grid: {
                        show: true,
                        strokeDashArray: 4,
                        borderColor: '#e0e0e0',
                        position: 'back'
                    },
                    stroke: {
                        width: 0
                    },
                    dataLabels: {
                        enabled: false
                    },
                    plotOptions: {
                        bar: {
                            columnWidth: '50%',
                            horizontal: false
                        }
                    },
                    colors: ['#FFA500', '#00A86B'],
                    series: [
                        {
                            name: 'Withdrawals',
                            data: withdrawalsChart.values
                        },
                        {
                            name: 'Deposits',
                            data: depositsChart.values
                        }
                    ],
                    fill: {
                        opacity: 1
                    },
                    labels: depositsChart.labels,
                    xaxis: {
                        categories: depositsChart.labels,
                        title: {
                            text: 'Months',
                            style: {
                                fontSize: '14px',
                                fontWeight: 'bold',
                                color: '#333'
                            }
                        },
                        labels: {
                            show: true
                        },
                        axisTicks: {
                            show: true
                        },
                        axisBorder: {
                            show: true
                        }
                    },
                    yaxis: {
                        min: 0,
                        title: {
                            text: 'Amount',
                            style: {
                                fontSize: '14px',
                                fontWeight: 'bold',
                                color: '#333'
                            }
                        }
                    },
                    tooltip: {
                        shared: true,
                        intersect: false,
                        y: {
                            formatter: function (y) {
                                return typeof y !== "undefined" ? "<?php echo e(__($general->cur_sym)); ?>" + y.toFixed(0) : y;
                            }
                        }
                    },
                    legend: {
                        labels: {
                            useSeriesColors: true
                        }
                    }
                };

                var chart = new ApexCharts(document.querySelector("#account-chart"), options);
                chart.render();
            })(jQuery)
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>