<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'type' => null,
    'image' => null,
    'imagePath' => null,
    'size' => null,
    'name' => 'image',
    'tigerId' => 'browserTrigger',
    'accept' => '.png, .jpg, .jpeg',
    'required' => true,
    'id' => 'image-input-' . uniqid(),
    'whiteLogoClass' => false,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'type' => null,
    'image' => null,
    'imagePath' => null,
    'size' => null,
    'name' => 'image',
    'tigerId' => 'browserTrigger',
    'accept' => '.png, .jpg, .jpeg',
    'required' => true,
    'id' => 'image-input-' . uniqid(),
    'whiteLogoClass' => false,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>
<?php
    $size = $size ?? getFileSize($type);
    $preview = $imagePath ?? getImage(getFilePath($type) . '/' . $image, $size);
    $hasImage = !empty($preview);
?>

<div class="image-upload--container br--solid-dash radius--base d-flex flex-column justify-content-center align-items-center">
    <div class="thumb--wrap d-flex justify-content-center align-items-center flex-shrink-0 position-relative">
        <div class="no-image-icon d-none">
            <i class="fa-regular fa-image fa-2x text-muted"></i>
        </div>

        <img class="preview-image image--preview <?php echo e($whiteLogoClass ? 'bg__gray' : ''); ?>" src="<?php echo e($imagePath); ?>" alt="<?php echo e(keyToTitle($name)); ?> <?php echo app('translator')->get('Image'); ?>" />

        <span class="remove-image cross--icon position-absolute d-flex align-items-center justify-content-center cursor-pointer">
            <i class="fa-solid fa-xmark"></i>
        </span>
    </div>
    <div class="content--wrap d-flex flex-column justify-center align-items-center">
        <i class="fa-solid fa-cloud-arrow-up"></i>
        <h6>
            <?php echo app('translator')->get('Drag files here or'); ?>
            <span class="text--primary cursor-pointer browse-trigger"><?php echo app('translator')->get('browse'); ?></span>
        </h6>
        <p class="text-center"><?php echo app('translator')->get('Supported Files:'); ?> <span class="text-black"><?php echo e($accept); ?></span>.
            <?php echo app('translator')->get('Image will be resized into'); ?> <span class="text-black"><?php echo e($size); ?><?php echo app('translator')->get('px'); ?></span>
        </p>
    </div>
    <input type="file" accept="<?php echo e($accept); ?>" name="<?php echo e($name); ?>" id="<?php echo e($id); ?>" class="file-input" hidden <?php if($required): echo 'required'; endif; ?>/>
</div>

<?php $__env->startPush('script'); ?>
   <script>
        $(function () {
            "use strict";
            $('.image-upload--container').each(function () {
                const $container = $(this);
                const $fileInput = $container.find('.file-input');
                const $previewImage = $container.find('.preview-image');
                const $browseTrigger = $container.find('.browse-trigger');
                const $removeImage = $container.find('.remove-image');
                const $noImageIcon = $container.find('.no-image-icon');

                function openFileInput(input) {
                    input.dispatchEvent(new MouseEvent('click', { bubbles: true }));
                }

                $browseTrigger.off('click').on('click', () => openFileInput($fileInput[0]));

                $fileInput.off('change').on('change', e => {
                    handleFile(e.target.files[0]);
                });

                $container.off('dragover').on('dragover', e => {
                    e.preventDefault();
                    $container.addClass('dragover');
                });

                $container.off('dragleave').on('dragleave', () => {
                    $container.removeClass('dragover');
                });

                $container.off('drop').on('drop', e => {
                    e.preventDefault();
                    $container.removeClass('dragover');
                    const file = e.originalEvent.dataTransfer.files[0];
                    handleFile(file);
                });

                function handleFile(file) {
                    if (!file || !file.type.startsWith('image/')) return;

                    const reader = new FileReader();
                    reader.onload = function (e) {
                        $previewImage.attr('src', e.target.result).show();
                        $removeImage.css('display', 'flex');
                        $noImageIcon.addClass('d-none');
                        $container.addClass('has-image');

                        const dataTransfer = new DataTransfer();
                        dataTransfer.items.add(file);
                        $fileInput[0].files = dataTransfer.files;
                    };
                    reader.readAsDataURL(file);
                }

                $removeImage.off('click').on('click', () => {
                    $previewImage.attr('src', '').hide();
                    $removeImage.hide();
                    $noImageIcon.removeClass('d-none');
                    $fileInput.val('');
                    $container.removeClass('has-image');
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/absendig/public_html/berita.absendigitalku.com/application/resources/views/components/image-uploader.blade.php ENDPATH**/ ?>